/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support.hops;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.support.hops.VertexHopCriteria;
import org.opennms.features.topology.api.topo.VertexRef;

public class WrappedVertexHopCriteria
extends VertexHopCriteria {
    private final Set<VertexHopCriteria> criteriaList;

    public WrappedVertexHopCriteria(Set<VertexHopCriteria> vertexHopCriterias) {
        super("Wrapped Vertex Hop Criteria for all VertexHopCriteria in the currently selected GraphProvider");
        this.criteriaList = Objects.requireNonNull(vertexHopCriterias);
    }

    public void addCriteria(VertexHopCriteria criteria) {
        this.criteriaList.add(criteria);
    }

    @Override
    public Set<VertexRef> getVertices() {
        Set<VertexRef> vertices = this.criteriaList.stream().flatMap(criteria -> criteria.getVertices().stream()).collect(Collectors.toSet());
        return vertices;
    }

    @Override
    public String getNamespace() {
        return "$wrapped$";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.criteriaList);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof WrappedVertexHopCriteria) {
            WrappedVertexHopCriteria other = (WrappedVertexHopCriteria)obj;
            return Objects.equals(this.criteriaList, other.criteriaList);
        }
        return false;
    }

    public boolean contains(VertexRef vertexRef) {
        return this.getVertices().contains(vertexRef);
    }
}

