/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Header;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.InformationElement;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerAccessor;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.TLV;

public class InitiationPacket
implements Packet {
    public final Header header;
    public final TLV.List<InformationElement, InformationElement.Type, String> information;

    public InitiationPacket(Header header, ByteBuf buffer, PeerAccessor peerAccessor) throws InvalidPacketException {
        this.header = Objects.requireNonNull(header);
        this.information = TLV.List.wrap(BufferUtils.repeatRemaining((ByteBuf)buffer, b -> new InformationElement(b, Optional.empty())));
    }

    @Override
    public void accept(Packet.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <R> R map(Packet.Mapper<R> mapper) {
        return mapper.map(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("information", this.information).toString();
    }
}

