/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.vmware;

import com.vmware.vim25.VimPortType;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.ws.Client;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.protocols.vmware.ServiceInstancePool;

public class ServiceInstancePoolEntry {
    private final String hostname;
    private final String username;
    private final String password;
    private final ServiceInstancePool serviceInstancePool;
    private Set<ServiceInstance> locked = new HashSet<ServiceInstance>();
    private Set<ServiceInstance> unlocked = new HashSet<ServiceInstance>();
    private Map<ServiceInstance, Long> accessTimestamp = new HashMap<ServiceInstance, Long>();

    public ServiceInstancePoolEntry(ServiceInstancePool serviceInstancePool, String hostname, String username, String password) {
        this.serviceInstancePool = serviceInstancePool;
        this.hostname = hostname;
        this.username = username;
        this.password = password;
    }

    public synchronized ServiceInstance retain(int timeout) throws MalformedURLException, RemoteException {
        ServiceInstance serviceInstance;
        if (this.unlocked.size() > 0) {
            serviceInstance = this.unlocked.iterator().next();
            if (this.serviceInstancePool.validate(serviceInstance)) {
                this.unlocked.remove(serviceInstance);
                this.locked.add(serviceInstance);
                ServiceInstancePoolEntry.setTimeout(serviceInstance, timeout);
                this.accessTimestamp.put(serviceInstance, System.currentTimeMillis());
                return serviceInstance;
            }
            this.unlocked.remove(serviceInstance);
            this.accessTimestamp.remove(serviceInstance);
        }
        serviceInstance = this.serviceInstancePool.create(this.hostname, this.username, this.password, timeout);
        this.locked.add(serviceInstance);
        this.accessTimestamp.put(serviceInstance, System.currentTimeMillis());
        return serviceInstance;
    }

    public static void setTimeout(ServiceInstance serviceInstance, int timeout) {
        Client client;
        VimPortType vimService;
        ServerConnection serverConnection;
        if (serviceInstance != null && (serverConnection = serviceInstance.getServerConnection()) != null && (vimService = serverConnection.getVimService()) != null && (client = vimService.getWsc()) != null) {
            client.setConnectTimeout(timeout);
            client.setReadTimeout(timeout);
        }
    }

    public synchronized void expire(long ageInMilliseconds) {
        long now = System.currentTimeMillis();
        this.unlocked.removeIf(e -> {
            if (!this.accessTimestamp.containsKey(e) || now - this.accessTimestamp.get(e) > ageInMilliseconds) {
                if (e.getServerConnection() != null) {
                    e.getServerConnection().logout();
                }
                return true;
            }
            return !this.serviceInstancePool.validate((ServiceInstance)e);
        });
        this.locked.removeIf(e -> {
            if (!this.accessTimestamp.containsKey(e) || now - this.accessTimestamp.get(e) > ageInMilliseconds) {
                return !this.serviceInstancePool.validate((ServiceInstance)e);
            }
            return false;
        });
        this.accessTimestamp.entrySet().removeIf(e -> !this.locked.contains(e.getKey()) && !this.unlocked.contains(e.getKey()));
    }

    public synchronized boolean isUnused() {
        return this.locked.isEmpty() && this.unlocked.isEmpty();
    }

    public synchronized void release(ServiceInstance serviceInstance) {
        if (serviceInstance == null) {
            return;
        }
        if (this.locked.remove(serviceInstance)) {
            this.unlocked.add(serviceInstance);
            this.accessTimestamp.put(serviceInstance, System.currentTimeMillis());
        }
    }

    public int lockedEntryCount() {
        return this.locked.size();
    }

    public int unlockedEntryCount() {
        return this.unlocked.size();
    }

    protected Map<ServiceInstance, Long> getAccessTimestamp() {
        return this.accessTimestamp;
    }
}

