/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.pagesequence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.pagesequence.Page;

@XmlRootElement(name="page-sequence")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="page-sequence.xsd")
public class PageSequence
implements Serializable {
    private static final long serialVersionUID = -6988812331650282380L;
    @XmlElement(name="page", required=true)
    private List<Page> m_pages = new ArrayList<Page>();

    public List<Page> getPages() {
        if (this.m_pages == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_pages);
    }

    public void setPages(List<Page> pages) {
        this.m_pages = new ArrayList<Page>(pages);
    }

    public void addPage(Page page) throws IndexOutOfBoundsException {
        this.m_pages.add(page);
    }

    public boolean removePage(Page page) {
        return this.m_pages.remove(page);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_pages == null ? 0 : this.m_pages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PageSequence)) {
            return false;
        }
        PageSequence other = (PageSequence)obj;
        return !(this.m_pages == null ? other.m_pages != null : !this.m_pages.equals(other.m_pages));
    }

    public String toString() {
        return "PageSequence [pages=" + String.valueOf(this.m_pages) + "]";
    }
}

