/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.google;

import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.errors.ApiException;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opennms.features.geocoder.GeocoderConfigurationException;
import org.opennms.features.geocoder.GeocoderResult;
import org.opennms.features.geocoder.GeocoderService;
import org.opennms.features.geocoder.google.GoogleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleGeocoderService
implements GeocoderService {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleGeocoderService.class);
    private final GoogleConfiguration configuration;

    public GoogleGeocoderService(GoogleConfiguration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    public String getId() {
        return "google";
    }

    public synchronized GeocoderResult resolveAddress(String address) throws GeocoderConfigurationException {
        this.configuration.validate();
        LOG.debug("Configuration: {}", this.configuration.asMap());
        GeoApiContext.Builder builder = new GeoApiContext.Builder().readTimeout((long)this.configuration.getTimeout(), TimeUnit.MILLISECONDS).connectTimeout((long)this.configuration.getTimeout(), TimeUnit.MILLISECONDS).maxRetries(Integer.valueOf(1));
        if (this.configuration.isUseSystemProxy()) {
            String targetUrl = "https://maps.googleapis.com";
            try {
                Proxy proxy = this.selectProxy("https://maps.googleapis.com");
                builder.proxy(proxy);
            }
            catch (URISyntaxException e) {
                return GeocoderResult.error((String)"Couldn't find proxy for URL: 'https://maps.googleapis.com'").build();
            }
        }
        if (this.configuration.isUseEnterpriseCredentials()) {
            builder.enterpriseCredentials(this.configuration.getClientId(), this.configuration.getSignature());
        } else {
            builder.apiKey(this.configuration.getApiKey());
        }
        try {
            GeoApiContext context = builder.build();
            GeocodingResult[] results = (GeocodingResult[])GeocodingApi.geocode((GeoApiContext)context, (String)address).await();
            LOG.trace("API returned {} results. If multiple, first is used.", (Object)results.length);
            if (results.length > 0 && results[0].geometry != null && results[0].geometry.location != null) {
                LatLng location = results[0].geometry.location;
                LOG.trace("API returned a result with valid long/lat fields: {}/{}", (Object)location.lng, (Object)location.lat);
                return GeocoderResult.success((String)address, (double)location.lng, (double)location.lat).build();
            }
            LOG.debug("API returned a result, but long/lat fields were missing: {}", (Object)results[0]);
            LOG.debug("Couldn't resolve coordinates for address {}", (Object)address);
            return GeocoderResult.noResult((String)address).build();
        }
        catch (ApiException | IOException | InterruptedException e) {
            return GeocoderResult.error((Exception)e).build();
        }
    }

    public GoogleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void validateConfiguration(Map<String, Object> properties) throws GeocoderConfigurationException {
        GoogleConfiguration.fromMap(properties).validate();
    }

    private Proxy selectProxy(String targetUri) throws URISyntaxException {
        List<Proxy> proxies = ProxySelector.getDefault().select(new URI(targetUri));
        return proxies.stream().filter(proxy -> proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.HTTP).findFirst().orElse(Proxy.NO_PROXY);
    }
}

