/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.resource;

import com.google.common.cache.CacheLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Named;
import org.opennms.core.cache.Cache;
import org.opennms.core.cache.CacheBuilder;
import org.opennms.core.cache.CacheConfig;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.TagMatcher;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTagMatcher;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.timeseries.TimeseriesStorageManager;
import org.opennms.netmgt.timeseries.util.TimeseriesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TimeseriesSearcher {
    private static final Logger LOG = LoggerFactory.getLogger(TimeseriesSearcher.class);
    private final TimeseriesStorageManager timeseriesStorageManager;
    private final Cache<TagMatcher, Set<Metric>> indexMetricsByTagMatcher;
    private final MetricCacheLoader metricCacheLoader;

    @Autowired
    public TimeseriesSearcher(TimeseriesStorageManager timeseriesStorageManager, @Named(value="timeseriesSearcherCache") CacheConfig cacheConfig) {
        this.timeseriesStorageManager = Objects.requireNonNull(timeseriesStorageManager, "timeseriesStorageManager must not be null");
        this.metricCacheLoader = new MetricCacheLoader(timeseriesStorageManager);
        this.indexMetricsByTagMatcher = new CacheBuilder().withConfig(cacheConfig).withCacheLoader((CacheLoader)this.metricCacheLoader).build();
    }

    private Set<Metric> getMetricsBelowWildcardPath(String wildcardPath) throws StorageException {
        TagMatcher tagMatcher = ImmutableTagMatcher.builder().type(TagMatcher.Type.EQUALS_REGEX).key("resourceId").value(wildcardPath + "/.*$").build();
        return this.getMetricFromCacheOrLoad(tagMatcher);
    }

    protected void buildCache(Set<Metric> metrics) {
        block0: for (Metric metric : metrics) {
            ResourcePath pathOfMetric;
            ResourcePath currentPath = pathOfMetric = ResourcePath.fromString((String)metric.getFirstTagByKey("resourceId").getValue());
            while (true) {
                TagMatcher matcher = ImmutableTagMatcher.builder().type(TagMatcher.Type.EQUALS_REGEX).key("resourceId").value(TimeseriesUtils.toSearchRegex(currentPath, pathOfMetric.elements().length - currentPath.elements().length)).build();
                this.getMetricsFromCacheOrAddEmptySet(matcher).add(metric);
                if (!currentPath.hasParent()) continue block0;
                currentPath = currentPath.getParent();
            }
        }
    }

    public Set<Metric> search(ResourcePath path, int depth) throws StorageException {
        TagMatcher indexMatcher = ImmutableTagMatcher.builder().type(TagMatcher.Type.EQUALS_REGEX).key("resourceId").value(TimeseriesUtils.toSearchRegex(path, depth + 1)).build();
        Set<Metric> metrics = (Set<Metric>)this.indexMetricsByTagMatcher.getIfCached((Object)indexMatcher);
        if (metrics != null) {
            return metrics;
        }
        int numPathElementsToNodeLevel = ResourceTypeUtils.getNumPathElementsToNodeLevel((ResourcePath)path);
        if (numPathElementsToNodeLevel > 0) {
            String wildcardPath = TimeseriesUtils.toResourceId(ResourcePath.get(Arrays.asList(path.elements()).subList(0, numPathElementsToNodeLevel)));
            this.getMetricsBelowWildcardPath(wildcardPath);
            metrics = this.getMetricsFromCacheOrAddEmptySet(indexMatcher);
        } else {
            metrics = this.getMetricFromCacheOrLoad(indexMatcher);
        }
        return metrics;
    }

    private Set<Metric> getMetricFromCacheOrLoad(TagMatcher matcher) throws StorageException {
        try {
            AtomicBoolean loaded = new AtomicBoolean(false);
            Set metrics = (Set)this.indexMetricsByTagMatcher.get((Object)matcher, () -> {
                loaded.set(true);
                return this.metricCacheLoader.load(matcher);
            });
            if (loaded.get()) {
                this.buildCache(metrics);
            }
            return metrics;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    private Set<Metric> getMetricsFromCacheOrAddEmptySet(TagMatcher tagMatcher) {
        try {
            return (Set)this.indexMetricsByTagMatcher.get((Object)tagMatcher, ConcurrentHashMap::newKeySet);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error creating ConcurrentHashMap.newKeySet()", e);
        }
    }

    private static final class MetricCacheLoader
    extends CacheLoader<TagMatcher, Set<Metric>> {
        private TimeseriesStorageManager timeseriesStorageManager;

        public MetricCacheLoader(TimeseriesStorageManager timeseriesStorageManager) {
            this.timeseriesStorageManager = timeseriesStorageManager;
        }

        public Set<Metric> load(TagMatcher tagMatcher) throws Exception {
            List metricList = this.timeseriesStorageManager.get().findMetrics(Collections.singletonList(tagMatcher));
            ConcurrentHashMap.KeySetView metrics = ConcurrentHashMap.newKeySet();
            metrics.addAll(metricList);
            return metrics;
        }
    }
}

