/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.resource;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.StringPropertyAttribute;
import org.opennms.netmgt.timeseries.TimeseriesStorageManager;
import org.opennms.netmgt.timeseries.resource.TimeseriesSearcher;
import org.opennms.netmgt.timeseries.util.TimeseriesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TimeseriesResourceStorageDao
implements ResourceStorageDao {
    private static final Logger LOG = LoggerFactory.getLogger(TimeseriesResourceStorageDao.class);
    @Autowired
    private TimeseriesStorageManager storageManager;
    @Autowired
    private TimeseriesSearcher searcher;

    public boolean exists(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"depth must be non-negative");
        return this.searchFor(path, depth).size() > 0;
    }

    public boolean existsWithin(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"depth must be non-negative");
        return IntStream.rangeClosed(0, depth).anyMatch(i -> this.searchFor(path, i).size() > 0);
    }

    public Set<ResourcePath> children(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"depth must be non-negative");
        TreeSet matches = Sets.newTreeSet();
        Set<Metric> metrics = this.searchFor(path, depth);
        for (Metric metric : metrics) {
            ResourcePath child = TimeseriesResourceStorageDao.toChildResourcePath(path, metric.getFirstTagByKey("resourceId").getValue());
            if (child == null) {
                LOG.warn("Encountered non-child resource {} when searching for {} with depth {}. Ignoring resource.", new Object[]{metric.getFirstTagByKey("resourceId").getValue(), path, depth});
                continue;
            }
            matches.add(child);
        }
        return matches;
    }

    public boolean delete(ResourcePath path) {
        Set<Metric> results = this.searchFor(path, 0);
        if (results.isEmpty()) {
            return false;
        }
        for (Metric metric : results) {
            try {
                this.storageManager.get().delete(metric);
            }
            catch (StorageException e) {
                LOG.error("Could not delete {}, will ignore problem and continue ", (Object)metric, (Object)e);
            }
        }
        return true;
    }

    public Set<OnmsAttribute> getAttributes(ResourcePath path) {
        HashSet attributes = Sets.newHashSet();
        Set<Metric> metrics = this.searchFor(path, 0);
        for (Metric metric : metrics) {
            String resourceId = metric.getFirstTagByKey("resourceId").getValue();
            ResourcePath resultPath = TimeseriesUtils.toResourcePath(resourceId);
            if (!path.equals((Object)resultPath) && !Arrays.stream(path.elements()).map(String::trim).collect(Collectors.toList()).equals(Arrays.asList(resultPath.elements()))) {
                LOG.warn("Encountered non-child resource {} when searching for {} with depth {}. Ignoring resource.", new Object[]{resourceId, path, 0});
                continue;
            }
            if (ResourceTypeUtils.isResponseTime((String)resourceId) || ResourceTypeUtils.isStatus((String)resourceId)) {
                attributes.add(new RrdGraphAttribute(TimeseriesUtils.toMetricName(resourceId), "", resourceId));
                continue;
            }
            attributes.add(new RrdGraphAttribute(metric.getFirstTagByKey("name").getValue(), "", resourceId));
        }
        HashSet<Metric> metricsWithStringAttributes = new HashSet<Metric>(metrics);
        metricsWithStringAttributes.addAll(this.searchFor(path, -1));
        if (!metricsWithStringAttributes.isEmpty()) {
            ((Metric)metricsWithStringAttributes.iterator().next()).getExternalTags().stream().map(t -> new StringPropertyAttribute(t.getKey(), t.getValue())).forEach(attributes::add);
        }
        return attributes;
    }

    public void setStringAttribute(ResourcePath path, String key, String value) {
        throw new UnsupportedOperationException("This method is not supported anymore. Please use KV store instead.");
    }

    public String getStringAttribute(ResourcePath path, String key) {
        return this.getStringAttributes(path).get(key);
    }

    public Map<String, String> getStringAttributes(ResourcePath path) {
        return this.getMetaData(path);
    }

    public Map<String, String> getMetaData(ResourcePath path) {
        HashSet<Metric> metricsWithStringAttributes = new HashSet<Metric>();
        metricsWithStringAttributes.addAll(this.searchFor(path, 0));
        metricsWithStringAttributes.addAll(this.searchFor(path, -1));
        return metricsWithStringAttributes.stream().flatMap(m -> m.getExternalTags().stream()).distinct().filter(t -> !t.getKey().endsWith("mtype")).collect(Collectors.toMap(Tag::getKey, Tag::getValue));
    }

    public void updateMetricToResourceMappings(ResourcePath path, Map<String, String> metricsNameToResourceNames) {
    }

    private Set<Metric> searchFor(ResourcePath path, int depth) {
        Set<Metric> results;
        try {
            results = this.searcher.search(path, depth);
            LOG.trace("Found {} results.", (Object)results.size());
        }
        catch (StorageException e) {
            LOG.error("An error occurred while querying for {}", (Object)path, (Object)e);
            throw new RuntimeException(e);
        }
        return results;
    }

    protected static ResourcePath toChildResourcePath(ResourcePath parent, String resourceId) {
        ResourcePath child = TimeseriesUtils.toResourcePath(resourceId);
        String[] childEls = child.elements();
        String[] parentEls = parent.elements();
        if (childEls == null || parentEls == null || childEls.length <= parentEls.length) {
            return null;
        }
        String[] els = new String[parentEls.length + 1];
        for (int i = 0; i <= parentEls.length; ++i) {
            els[i] = childEls[i];
        }
        return ResourcePath.get((String[])els);
    }

    public void setSearcher(TimeseriesSearcher searcher) {
        this.searcher = searcher;
    }
}

