/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.util.Map;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.TimerExpression;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.BaseTimer;
import org.drools.core.time.impl.CronExpression;
import org.drools.core.time.impl.CronTrigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.Timer;
import org.kie.api.runtime.Calendars;

public class CronTimer
extends BaseTimer
implements Timer,
Externalizable {
    private TimerExpression startTime;
    private TimerExpression endTime;
    private int repeatLimit;
    private CronExpression cronExpression;

    public CronTimer() {
    }

    public CronTimer(TimerExpression startTime, TimerExpression endTime, int repeatLimit, CronExpression cronExpression) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.repeatLimit = repeatLimit;
        this.cronExpression = cronExpression;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.startTime);
        out.writeObject(this.endTime);
        out.writeInt(this.repeatLimit);
        out.writeObject(this.cronExpression.getCronExpression());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startTime = (TimerExpression)in.readObject();
        this.endTime = (TimerExpression)in.readObject();
        this.repeatLimit = in.readInt();
        String string = (String)in.readObject();
        try {
            this.cronExpression = new CronExpression(string);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to marshal CronExpression '" + string + "'", e);
        }
    }

    private Declaration[] getStartDeclarations() {
        return this.startTime != null ? this.startTime.getDeclarations() : null;
    }

    private Declaration[] getEndDeclarations() {
        return this.endTime != null ? this.endTime.getDeclarations() : null;
    }

    @Override
    public Declaration[][] getTimerDeclarations(Map<String, Declaration> outerDeclrs) {
        return new Declaration[][]{this.sortDeclarations(outerDeclrs, this.getStartDeclarations()), this.sortDeclarations(outerDeclrs, this.getEndDeclarations())};
    }

    public CronExpression getCronExpression() {
        return this.cronExpression;
    }

    @Override
    public Trigger createTrigger(long timestamp, Tuple leftTuple, DefaultJobHandle jh, String[] calendarNames, Calendars calendars, Declaration[][] declrs, ReteEvaluator reteEvaluator) {
        Declaration[] startDeclarations = declrs[0];
        return new CronTrigger(timestamp, TimeUtils.evalDateExpression(this.startTime, leftTuple, startDeclarations, reteEvaluator), TimeUtils.evalDateExpression(this.endTime, leftTuple, startDeclarations, reteEvaluator), this.repeatLimit, this.cronExpression, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        return new CronTrigger(timestamp, null, null, this.repeatLimit, this.cronExpression, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cronExpression.getCronExpression() == null ? 0 : this.cronExpression.getCronExpression().hashCode());
        result = 31 * result + this.repeatLimit;
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CronTimer other = (CronTimer)obj;
        if (this.repeatLimit != other.repeatLimit) {
            return false;
        }
        if (this.cronExpression.getCronExpression() == null ? other.cronExpression.getCronExpression() != null : !this.cronExpression.getCronExpression().equals(other.cronExpression.getCronExpression())) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }

    @Override
    public ConditionalElement clone() {
        return new CronTimer(this.startTime, this.endTime, this.repeatLimit, this.cronExpression);
    }
}

