/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.factory;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.telemetry.api.receiver.Listener;
import org.opennms.netmgt.telemetry.api.receiver.ListenerFactory;
import org.opennms.netmgt.telemetry.api.registry.TelemetryRegistry;
import org.opennms.netmgt.telemetry.config.api.ListenerDefinition;
import org.opennms.netmgt.telemetry.listeners.TcpListener;
import org.opennms.netmgt.telemetry.listeners.TcpParser;

public class TcpListenerFactory
implements ListenerFactory {
    private final TelemetryRegistry telemetryRegistry;

    public TcpListenerFactory(TelemetryRegistry telemetryRegistry) {
        this.telemetryRegistry = Objects.requireNonNull(telemetryRegistry);
    }

    public Class<? extends Listener> getBeanClass() {
        return TcpListener.class;
    }

    public Listener createBean(ListenerDefinition listenerDefinition) {
        if (listenerDefinition.getParsers().size() != 1) {
            throw new IllegalArgumentException("The simple TCP listener supports exactly one parser");
        }
        List parser = listenerDefinition.getParsers().stream().map(p -> this.telemetryRegistry.getParser(p)).filter(p -> p instanceof TcpParser && p != null).map(p -> (TcpParser)p).collect(Collectors.toList());
        if (parser.size() != listenerDefinition.getParsers().size()) {
            throw new IllegalArgumentException("Each parser must be of type TcpParser but was not.");
        }
        return new TcpListener(listenerDefinition.getName(), (TcpParser)parser.iterator().next(), this.telemetryRegistry.getMetricRegistry());
    }
}

