/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dnsresolver.netty;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.netty.resolver.dns.DnsNameResolverTimeoutException;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.SequentialDnsServerAddressStreamProvider;
import io.netty.util.internal.SocketUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.dnsresolver.netty.CaffeineDnsCache;
import org.opennms.netmgt.dnsresolver.netty.NettyResolverContext;
import org.opennms.netmgt.dnsresolver.netty.RandomIterator;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyDnsResolver
implements DnsResolver {
    private static final Logger LOG = LoggerFactory.getLogger(NettyDnsResolver.class);
    public static final String CIRCUIT_BREAKER_STATE_CHANGE_EVENT_UEI = "uei.opennms.org/circuitBreaker/stateChange";
    private final EventForwarder eventForwarder;
    private final MetricRegistry metrics;
    private final Timer lookupTimer;
    private final Meter lookupsSuccessful;
    private final Meter lookupsFailed;
    private final Meter lookupsRejectedByCircuitBreaker;
    private int numContexts = 0;
    private String nameservers = null;
    private long queryTimeoutMillis = TimeUnit.SECONDS.toMillis(5L);
    private int minTtlSeconds = -1;
    private int maxTtlSeconds = -1;
    private int negativeTtlSeconds = -1;
    private long maxCacheSize = -1L;
    private boolean breakerEnabled = true;
    private int breakerFailureRateThreshold = 80;
    private int breakerWaitDurationInOpenState = 15;
    private int breakerRingBufferSizeInHalfOpenState = 10;
    private int breakerRingBufferSizeInClosedState = 100;
    private int bulkheadMaxConcurrentCalls = 1000;
    private long bulkheadMaxWaitDurationMillis = this.queryTimeoutMillis + 100L;
    private List<NettyResolverContext> contexts;
    private Iterator<NettyResolverContext> iterator;
    private CaffeineDnsCache cache;
    private Bulkhead bulkhead;
    private CircuitBreaker circuitBreaker;

    public NettyDnsResolver(EventForwarder eventForwarder, MetricRegistry metrics) {
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
        this.metrics = Objects.requireNonNull(metrics);
        this.lookupTimer = metrics.timer("lookups");
        this.lookupsSuccessful = metrics.meter("lookupsSuccessful");
        this.lookupsFailed = metrics.meter("lookupsFailed");
        this.lookupsRejectedByCircuitBreaker = metrics.meter("lookupsRejectedByCircuitBreaker");
        metrics.register("availableConcurrentCalls", (Metric)((Gauge)() -> this.bulkhead.getMetrics().getAvailableConcurrentCalls()));
        metrics.register("maxAllowedConcurrentCalls", (Metric)((Gauge)() -> this.bulkhead.getMetrics().getMaxAllowedConcurrentCalls()));
    }

    public void init() {
        this.numContexts = Math.max(0, this.numContexts);
        if (this.numContexts == 0) {
            this.numContexts = Runtime.getRuntime().availableProcessors() * 2;
        }
        LOG.debug("Initializing Netty resolver with {} contexts and nameservers: {}", (Object)this.numContexts, (Object)this.nameservers);
        CaffeineDnsCache cacheWithDefaults = new CaffeineDnsCache();
        this.cache = new CaffeineDnsCache(this.minTtlSeconds < 0 ? cacheWithDefaults.minTtl() : this.minTtlSeconds, this.maxTtlSeconds < 0 ? cacheWithDefaults.maxTtl() : this.maxTtlSeconds, this.negativeTtlSeconds < 0 ? cacheWithDefaults.negativeTtl() : this.negativeTtlSeconds, this.maxCacheSize < 0L ? cacheWithDefaults.maxSize() : this.maxCacheSize);
        this.cache.registerMetrics(this.metrics);
        BulkheadConfig bulkheadConfig = BulkheadConfig.custom().maxConcurrentCalls(this.bulkheadMaxConcurrentCalls).maxWaitDuration(Duration.ofMillis(this.bulkheadMaxWaitDurationMillis)).build();
        this.bulkhead = Bulkhead.of((String)"nettyDnsResolver", (BulkheadConfig)bulkheadConfig);
        this.contexts = new ArrayList<NettyResolverContext>(this.numContexts);
        for (int i = 0; i < this.numContexts; ++i) {
            NettyResolverContext context = new NettyResolverContext(this, this.cache, this.bulkhead, i);
            context.init();
            this.contexts.add(context);
        }
        this.iterator = new RandomIterator<NettyResolverContext>(this.contexts).iterator();
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.custom().failureRateThreshold((float)this.breakerFailureRateThreshold).waitDurationInOpenState(Duration.ofSeconds(this.breakerWaitDurationInOpenState)).ringBufferSizeInHalfOpenState(this.breakerRingBufferSizeInHalfOpenState).ringBufferSizeInClosedState(this.breakerRingBufferSizeInClosedState).recordExceptions(new Class[]{DnsNameResolverTimeoutException.class}).build();
        this.circuitBreaker = CircuitBreaker.of((String)"nettyDnsResolver", (CircuitBreakerConfig)circuitBreakerConfig);
        this.circuitBreaker.getEventPublisher().onStateTransition(e -> {
            Event event = new EventBuilder(CIRCUIT_BREAKER_STATE_CHANGE_EVENT_UEI, NettyDnsResolver.class.getCanonicalName()).addParam("name", this.circuitBreaker.getName()).addParam("fromState", e.getStateTransition().getFromState().toString()).addParam("toState", e.getStateTransition().getToState().toString()).getEvent();
            this.eventForwarder.sendNow(event);
        }).onSuccess(e -> this.lookupsSuccessful.mark()).onError(e -> this.lookupsFailed.mark()).onCallNotPermitted(e -> this.lookupsRejectedByCircuitBreaker.mark());
        if (this.breakerEnabled) {
            this.circuitBreaker.transitionToClosedState();
        } else {
            this.circuitBreaker.transitionToDisabledState();
        }
    }

    public void destroy() {
        for (NettyResolverContext context : this.contexts) {
            try {
                context.destroy();
            }
            catch (Exception e) {
                LOG.warn("Error occurred while destroying context.", (Throwable)e);
            }
        }
        this.contexts.clear();
        this.cache.unregisterMetrics(this.metrics);
    }

    public CompletableFuture<Optional<InetAddress>> lookup(String hostname) {
        return this.circuitBreaker.executeCompletionStage(() -> {
            NettyResolverContext resolverContext = this.iterator.next();
            Timer.Context timerContext = this.lookupTimer.time();
            return resolverContext.lookup(hostname).whenComplete((res, ex) -> timerContext.stop());
        }).toCompletableFuture();
    }

    public CompletableFuture<Optional<String>> reverseLookup(InetAddress inetAddress) {
        return this.circuitBreaker.executeCompletionStage(() -> {
            NettyResolverContext resolverContext = this.iterator.next();
            Timer.Context timerContext = this.lookupTimer.time();
            return resolverContext.reverseLookup(inetAddress).whenComplete((res, ex) -> timerContext.stop());
        }).toCompletableFuture();
    }

    @VisibleForTesting
    CaffeineDnsCache getCache() {
        return this.cache;
    }

    public boolean getBreakerEnabled() {
        return this.breakerEnabled;
    }

    public void setBreakerEnabled(boolean breakerEnabled) {
        this.breakerEnabled = breakerEnabled;
    }

    public int getBreakerFailureRateThreshold() {
        return this.breakerFailureRateThreshold;
    }

    public void setBreakerFailureRateThreshold(int breakerFailureRateThreshold) {
        this.breakerFailureRateThreshold = breakerFailureRateThreshold;
    }

    public int getBreakerWaitDurationInOpenState() {
        return this.breakerWaitDurationInOpenState;
    }

    public void setBreakerWaitDurationInOpenState(int breakerWaitDurationInOpenState) {
        this.breakerWaitDurationInOpenState = breakerWaitDurationInOpenState;
    }

    public int getBreakerRingBufferSizeInHalfOpenState() {
        return this.breakerRingBufferSizeInHalfOpenState;
    }

    public void setBreakerRingBufferSizeInHalfOpenState(int breakerRingBufferSizeInHalfOpenState) {
        this.breakerRingBufferSizeInHalfOpenState = breakerRingBufferSizeInHalfOpenState;
    }

    public int getBreakerRingBufferSizeInClosedState() {
        return this.breakerRingBufferSizeInClosedState;
    }

    public void setBreakerRingBufferSizeInClosedState(int breakerRingBufferSizeInClosedState) {
        this.breakerRingBufferSizeInClosedState = breakerRingBufferSizeInClosedState;
    }

    public int getBulkheadMaxConcurrentCalls() {
        return this.bulkheadMaxConcurrentCalls;
    }

    public void setBulkheadMaxConcurrentCalls(int bulkheadMaxConcurrentCalls) {
        this.bulkheadMaxConcurrentCalls = bulkheadMaxConcurrentCalls;
    }

    public long getBulkheadMaxWaitDurationMillis() {
        return this.bulkheadMaxWaitDurationMillis;
    }

    public void setBulkheadMaxWaitDurationMillis(long bulkheadMaxWaitDurationMillis) {
        this.bulkheadMaxWaitDurationMillis = bulkheadMaxWaitDurationMillis;
    }

    public int getNumContexts() {
        return this.numContexts;
    }

    public void setNumContexts(int numContexts) {
        this.numContexts = numContexts;
    }

    public String getNameservers() {
        return this.nameservers;
    }

    public void setNameservers(String nameservers) {
        this.nameservers = nameservers;
    }

    public long getQueryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public void setQueryTimeoutMillis(long queryTimeoutMillis) {
        this.queryTimeoutMillis = queryTimeoutMillis;
    }

    public int getMinTtlSeconds() {
        return this.minTtlSeconds;
    }

    public void setMinTtlSeconds(int minTtlSeconds) {
        this.minTtlSeconds = minTtlSeconds;
    }

    public int getMaxTtlSeconds() {
        return this.maxTtlSeconds;
    }

    public void setMaxTtlSeconds(int maxTtlSeconds) {
        this.maxTtlSeconds = maxTtlSeconds;
    }

    public int getNegativeTtlSeconds() {
        return this.negativeTtlSeconds;
    }

    public void setNegativeTtlSeconds(int negativeTtlSeconds) {
        this.negativeTtlSeconds = negativeTtlSeconds;
    }

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public DnsServerAddressStreamProvider getNameServerProvider() {
        if (Strings.isNullOrEmpty((String)this.nameservers)) {
            return DnsServerAddressStreamProviders.platformDefault();
        }
        return new SequentialDnsServerAddressStreamProvider(NettyDnsResolver.toSocketAddresses(this.nameservers).toArray(new InetSocketAddress[0]));
    }

    public static List<InetSocketAddress> toSocketAddresses(String commaSeparatedAddressesWithPorts) {
        String[] servers = commaSeparatedAddressesWithPorts.split(",");
        return Arrays.stream(servers).map(s -> {
            HostAndPort hp = HostAndPort.fromString((String)s.trim()).withDefaultPort(53).requireBracketsForIPv6();
            return SocketUtils.socketAddress((String)hp.getHost(), (int)hp.getPort());
        }).collect(Collectors.toList());
    }
}

