/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.client.rpc;

import io.opentracing.Span;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.dto.CollectionAgentDTO;
import org.opennms.netmgt.collection.dto.CollectionAttributeDTO;

@XmlRootElement(name="collector-request")
@XmlAccessorType(value=XmlAccessType.NONE)
public class CollectorRequestDTO
implements RpcRequest {
    @XmlElement(name="agent", type=CollectionAgentDTO.class)
    private CollectionAgent agent;
    @XmlAttribute(name="location")
    private String location;
    @XmlAttribute(name="system-id")
    private String systemId;
    @XmlAttribute(name="class-name")
    private String className;
    @XmlAttribute(name="attributes-need-unmarshaling")
    private Boolean attributesNeedUnmarshaling;
    @XmlElement(name="attribute")
    private List<CollectionAttributeDTO> attributes = new ArrayList<CollectionAttributeDTO>();
    private Long timeToLiveMs;
    private Map<String, String> tracingInfo = new HashMap<String, String>();

    public CollectionAgent getAgent() {
        return this.agent;
    }

    public void setAgent(CollectionAgent agent) {
        this.agent = agent;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setTimeToLiveMs(Long timeToLiveMs) {
        this.timeToLiveMs = timeToLiveMs;
    }

    public Long getTimeToLiveMs() {
        return this.timeToLiveMs;
    }

    public Map<String, String> getTracingInfo() {
        return this.tracingInfo;
    }

    public Span getSpan() {
        return null;
    }

    public void addTracingInfo(String key, String value) {
        this.tracingInfo.put(key, value);
    }

    public Boolean getAttributesNeedUnmarshaling() {
        return this.attributesNeedUnmarshaling;
    }

    public void setAttributesNeedUnmarshaling(Boolean attributesNeedUnmarshaling) {
        this.attributesNeedUnmarshaling = attributesNeedUnmarshaling;
    }

    public List<CollectionAttributeDTO> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<CollectionAttributeDTO> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String key, Object value) {
        this.attributes.add(new CollectionAttributeDTO(key, value));
    }

    public void addAttributes(Map<String, Object> attributes) {
        attributes.entrySet().stream().forEach(e -> this.addAttribute((String)e.getKey(), e.getValue()));
    }

    public Map<String, Object> getParameters(ServiceCollector collector) {
        if (Boolean.TRUE.equals(this.attributesNeedUnmarshaling)) {
            HashMap parms = new HashMap();
            this.attributes.stream().forEach(a -> parms.put(a.getKey(), a.getValue()));
            return collector.unmarshalParameters(parms);
        }
        HashMap<String, Object> parms = new HashMap<String, Object>();
        this.attributes.stream().forEach(a -> parms.put(a.getKey(), a.getValueOrContents()));
        return parms;
    }

    public int hashCode() {
        return Objects.hash(this.agent, this.location, this.systemId, this.className, this.timeToLiveMs, this.attributesNeedUnmarshaling);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectorRequestDTO)) {
            return false;
        }
        CollectorRequestDTO other = (CollectorRequestDTO)obj;
        return Objects.equals(this.agent, other.agent) && Objects.equals(this.location, other.location) && Objects.equals(this.systemId, other.systemId) && Objects.equals(this.className, other.className) && Objects.equals(this.timeToLiveMs, other.timeToLiveMs) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.attributesNeedUnmarshaling, other.attributesNeedUnmarshaling);
    }
}

