/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.sink.dispatcher;

import java.net.InetAddress;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.MessageDispatcherFactory;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.distributed.core.api.Identity;
import org.opennms.features.deviceconfig.sink.module.DeviceConfigSinkDTO;
import org.opennms.features.deviceconfig.sink.module.DeviceConfigSinkModule;
import org.opennms.features.deviceconfig.tftp.TftpFileReceiver;
import org.opennms.features.deviceconfig.tftp.TftpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceConfigDispatcher
implements TftpFileReceiver,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceConfigDispatcher.class);
    private final Identity identity;
    private final TftpServer tftpServer;
    private final DeviceConfigSinkModule sinkModule;
    private final MessageDispatcherFactory messageDispatcherFactory;
    private final AsyncDispatcher<DeviceConfigSinkDTO> asyncDispatcher;

    public DeviceConfigDispatcher(Identity identity, TftpServer tftpServer, DeviceConfigSinkModule sinkModule, MessageDispatcherFactory messageDispatcherFactory) throws Exception {
        this.identity = identity;
        this.tftpServer = tftpServer;
        this.sinkModule = sinkModule;
        this.messageDispatcherFactory = messageDispatcherFactory;
        this.asyncDispatcher = messageDispatcherFactory.createAsyncDispatcher((SinkModule)sinkModule);
        tftpServer.register((TftpFileReceiver)this);
    }

    public void onFileReceived(InetAddress address, String fileName, byte[] content) {
        LOG.debug("received - address: " + address.getHostAddress() + "; fileName: " + fileName + "; contentLength: " + content.length);
        if (fileName.contains("monitor")) {
            return;
        }
        DeviceConfigSinkDTO dto = new DeviceConfigSinkDTO(this.identity.getLocation(), address.getAddress(), fileName, content);
        this.asyncDispatcher.send((Message)dto).whenComplete((status, throwable) -> {
            if (status != null) {
                LOG.debug("sent - address: " + address.getHostAddress() + "; fileName: " + fileName + "; dispatchStatus: " + status.name());
            }
        });
    }

    @Override
    public void close() throws Exception {
        this.asyncDispatcher.close();
        this.tftpServer.unregister((TftpFileReceiver)this);
    }
}

