/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.model.OspfArea;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;

public class OspfAreaTableTracker
extends TableTracker {
    public static final SnmpObjId OSPF_AREA_ID_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.2.1.1");
    public static final SnmpObjId OSPF_AUTH_TYPE_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.2.1.2");
    public static final SnmpObjId OSPF_IMPORT_AS_EXTERN_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.2.1.3");
    public static final SnmpObjId OSPF_AREA_BDR_RTR_COUNT_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.2.1.5");
    public static final SnmpObjId OSPF_AS_BDR_RTR_COUNT_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.2.1.6");
    public static final SnmpObjId OSPF_AREA_LSA_COUNT_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.2.1.7");
    public static final String OSPF_AREA_ID = "ospfAreaId";
    public static final String OSPF_AUTH_TYPE = "ospfAuthType";
    public static final String OSPF_IMPORT_AS_EXTERN = "ospfImportAsExtern";
    public static final String OSPF_AREA_BDR_RTR_COUNT = "ospfAreaBdrRtrCount";
    public static final String OSPF_AS_BDR_RTR_COUNT = "ospfAsBdrRtrCount";
    public static final String OSPF_AREA_LSA_COUNT = "ospfAreaLsaCount";
    public static final SnmpObjId[] s_ospfAreatable_elemList = new SnmpObjId[]{OSPF_AREA_ID_OID, OSPF_AUTH_TYPE_OID, OSPF_IMPORT_AS_EXTERN_OID, OSPF_AREA_BDR_RTR_COUNT_OID, OSPF_AS_BDR_RTR_COUNT_OID, OSPF_AREA_LSA_COUNT_OID};

    public OspfAreaTableTracker() {
        super(s_ospfAreatable_elemList);
    }

    public OspfAreaTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_ospfAreatable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new OspfAreaRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processOspfAreaRow((OspfAreaRow)row);
    }

    public void processOspfAreaRow(OspfAreaRow row) {
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_AREA_ID_OID) + "." + row.getInstance().toString(), OSPF_AREA_ID, InetAddressUtils.str((InetAddress)row.getOspfAreaId()));
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_AUTH_TYPE_OID) + "." + row.getInstance().toString(), OSPF_AUTH_TYPE, row.getOspfAuthType());
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_IMPORT_AS_EXTERN_OID) + "." + row.getInstance().toString(), OSPF_IMPORT_AS_EXTERN, row.getOspfImportAsExtern());
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_AREA_BDR_RTR_COUNT_OID) + "." + row.getInstance().toString(), OSPF_AREA_BDR_RTR_COUNT, row.getOspfAreaBdrRtrCount());
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_AS_BDR_RTR_COUNT_OID) + "." + row.getInstance().toString(), OSPF_AS_BDR_RTR_COUNT, row.getOspfAsBdrRtrCount());
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_AREA_LSA_COUNT_OID) + "." + row.getInstance().toString(), OSPF_AREA_LSA_COUNT, row.getOspfAreaLsaCount());
    }

    public static class OspfAreaRow
    extends SnmpRowResult {
        public OspfAreaRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public InetAddress getOspfAreaId() {
            return this.getValue(OSPF_AREA_ID_OID).toInetAddress();
        }

        public Integer getOspfAuthType() {
            return this.getValue(OSPF_AUTH_TYPE_OID).toInt();
        }

        public Integer getOspfImportAsExtern() {
            return this.getValue(OSPF_IMPORT_AS_EXTERN_OID).isNull() ? null : Integer.valueOf(this.getValue(OSPF_IMPORT_AS_EXTERN_OID).toInt());
        }

        public Integer getOspfAreaBdrRtrCount() {
            return this.getValue(OSPF_AREA_BDR_RTR_COUNT_OID).toInt();
        }

        public Integer getOspfAsBdrRtrCount() {
            return this.getValue(OSPF_AS_BDR_RTR_COUNT_OID).toInt();
        }

        public Integer getOspfAreaLsaCount() {
            return this.getValue(OSPF_AREA_LSA_COUNT_OID).toInt();
        }

        public OspfArea getOspfArea() {
            OspfArea area = new OspfArea();
            area.setOspfAreaId(this.getOspfAreaId());
            area.setOspfAuthType(this.getOspfAuthType());
            area.setOspfImportAsExtern(this.getOspfImportAsExtern());
            area.setOspfAreaBdrRtrCount(this.getOspfAreaBdrRtrCount());
            area.setOspfAsBdrRtrCount(this.getOspfAsBdrRtrCount());
            area.setOspfAreaLsaCount(this.getOspfAreaLsaCount());
            return area;
        }
    }
}

