/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.rest.impl;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.List;

public class JsonPathHelper {
    private static final Configuration AS_PATH_LIST = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();

    public static String get(String data, String path) {
        JsonPath jsonPath = JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
        return JsonPath.parse((String)data).read(jsonPath).toString();
    }

    public static String update(String data, String path, String newPartContent) {
        JsonPath jsonPath = JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
        JsonPathHelper.assertThereIsExactlyOnePath(data, jsonPath);
        Object newContentObject = Configuration.defaultConfiguration().jsonProvider().parse(newPartContent);
        return JsonPath.parse((String)data).set(jsonPath, newContentObject).jsonString();
    }

    public static String append(String data, String path, String newPartContent) {
        JsonPath jsonPath = JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
        JsonPathHelper.assertThereIsExactlyOnePath(data, jsonPath);
        Object newContentObject = Configuration.defaultConfiguration().jsonProvider().parse(newPartContent);
        return JsonPath.parse((String)data).add(jsonPath, newContentObject).jsonString();
    }

    public static String insertOrUpdateNode(String data, String parent, String nodeName, String newPartContent) {
        JsonPath jsonPath = JsonPath.compile((String)parent, (Predicate[])new Predicate[0]);
        JsonPathHelper.assertThereIsExactlyOnePath(data, jsonPath);
        Object newContentObject = Configuration.defaultConfiguration().jsonProvider().parse(newPartContent);
        return JsonPath.parse((String)data).put(parent, nodeName, newContentObject, new Predicate[0]).jsonString();
    }

    public static String delete(String data, String path) {
        JsonPath jsonPath = JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
        JsonPathHelper.assertThereIsExactlyOnePath(data, jsonPath);
        return JsonPath.parse((String)data).delete(jsonPath).jsonString();
    }

    private static int count(String data, JsonPath jsonPath) {
        List paths = (List)JsonPath.using((Configuration)AS_PATH_LIST).parse(data).read(jsonPath);
        return paths.size();
    }

    private static void assertThereIsExactlyOnePath(String data, JsonPath jsonPath) {
        if (JsonPathHelper.count(data, jsonPath) != 1) {
            throw new IllegalArgumentException("Path must resolve to a single element");
        }
    }
}

