/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.image.node.FeaturesImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.server.common.MetadataVersion;

public final class FeaturesImage {
    public static final FeaturesImage EMPTY = new FeaturesImage(Collections.emptyMap(), MetadataVersion.MINIMUM_KRAFT_VERSION, ZkMigrationState.NONE);
    private final Map<String, Short> finalizedVersions;
    private final MetadataVersion metadataVersion;
    private final ZkMigrationState zkMigrationState;

    public FeaturesImage(Map<String, Short> finalizedVersions, MetadataVersion metadataVersion, ZkMigrationState zkMigrationState) {
        this.finalizedVersions = Collections.unmodifiableMap(finalizedVersions);
        this.metadataVersion = metadataVersion;
        this.zkMigrationState = zkMigrationState;
    }

    public boolean isEmpty() {
        return this.finalizedVersions.isEmpty() && this.metadataVersion.equals((Object)MetadataVersion.MINIMUM_KRAFT_VERSION) && this.zkMigrationState.equals((Object)ZkMigrationState.NONE);
    }

    public MetadataVersion metadataVersion() {
        return this.metadataVersion;
    }

    public Map<String, Short> finalizedVersions() {
        return this.finalizedVersions;
    }

    public ZkMigrationState zkMigrationState() {
        return this.zkMigrationState;
    }

    private Optional<Short> finalizedVersion(String feature) {
        return Optional.ofNullable(this.finalizedVersions.get(feature));
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        if (options.metadataVersion().isLessThan(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION)) {
            this.handleFeatureLevelNotSupported(options);
        } else {
            this.writeFeatureLevels(writer, options);
        }
        if (options.metadataVersion().isMigrationSupported()) {
            writer.write(0, this.zkMigrationState.toRecord().message());
        } else if (!this.zkMigrationState.equals((Object)ZkMigrationState.NONE)) {
            options.handleLoss("the ZK Migration state which was " + (Object)((Object)this.zkMigrationState));
        }
    }

    private void handleFeatureLevelNotSupported(ImageWriterOptions options) {
        if (!this.finalizedVersions.isEmpty()) {
            ArrayList<String> features = new ArrayList<String>(this.finalizedVersions.keySet());
            features.sort(String::compareTo);
            options.handleLoss("feature flag(s): " + features.stream().collect(Collectors.joining(", ")));
        }
    }

    private void writeFeatureLevels(ImageWriter writer, ImageWriterOptions options) {
        writer.write(0, new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(options.metadataVersion().featureLevel()));
        for (Map.Entry<String, Short> entry : this.finalizedVersions.entrySet()) {
            if (entry.getKey().equals("metadata.version")) continue;
            writer.write(0, new FeatureLevelRecord().setName(entry.getKey()).setFeatureLevel(entry.getValue()));
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.finalizedVersions, this.metadataVersion, this.zkMigrationState});
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeaturesImage)) {
            return false;
        }
        FeaturesImage other = (FeaturesImage)o;
        return this.finalizedVersions.equals(other.finalizedVersions) && this.metadataVersion.equals((Object)other.metadataVersion) && this.zkMigrationState.equals((Object)other.zkMigrationState);
    }

    public String toString() {
        return new FeaturesImageNode(this).stringify();
    }
}

