/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2;

import java.nio.charset.StandardCharsets;
import org.opennms.shaded.org.bouncycastle.crypto.digests.SHA256Digest;
import org.opennms.shaded.org.bouncycastle.crypto.generators.KDFCounterBytesGenerator;
import org.opennms.shaded.org.bouncycastle.crypto.macs.HMac;
import org.opennms.shaded.org.bouncycastle.crypto.params.KDFCounterParameters;

final class Smb3KeyDerivation {
    private static final byte[] SIGNCONTEXT_300 = Smb3KeyDerivation.toCBytes("SmbSign");
    private static final byte[] SIGNLABEL_300 = Smb3KeyDerivation.toCBytes("SMB2AESCMAC");
    private static final byte[] SIGNLABEL_311 = Smb3KeyDerivation.toCBytes("SMBSigningKey");
    private static final byte[] APPCONTEXT_300 = Smb3KeyDerivation.toCBytes("SmbRpc");
    private static final byte[] APPLABEL_300 = Smb3KeyDerivation.toCBytes("SMB2APP");
    private static final byte[] APPLABEL_311 = Smb3KeyDerivation.toCBytes("SMBAppKey");
    private static final byte[] ENCCONTEXT_300 = Smb3KeyDerivation.toCBytes("ServerIn ");
    private static final byte[] ENCLABEL_300 = Smb3KeyDerivation.toCBytes("SMB2AESCCM");
    private static final byte[] ENCLABEL_311 = Smb3KeyDerivation.toCBytes("SMB2C2SCipherKey");
    private static final byte[] DECCONTEXT_300 = Smb3KeyDerivation.toCBytes("ServerOut");
    private static final byte[] DECLABEL_300 = Smb3KeyDerivation.toCBytes("SMB2AESCCM");
    private static final byte[] DECLABEL_311 = Smb3KeyDerivation.toCBytes("SMB2S2CCipherKey");

    private Smb3KeyDerivation() {
    }

    public static byte[] deriveSigningKey(int dialect, byte[] sessionKey, byte[] preauthIntegrity) {
        return Smb3KeyDerivation.derive(sessionKey, dialect == 785 ? SIGNLABEL_311 : SIGNLABEL_300, dialect == 785 ? preauthIntegrity : SIGNCONTEXT_300);
    }

    public static byte[] dervieApplicationKey(int dialect, byte[] sessionKey, byte[] preauthIntegrity) {
        return Smb3KeyDerivation.derive(sessionKey, dialect == 785 ? APPLABEL_311 : APPLABEL_300, dialect == 785 ? preauthIntegrity : APPCONTEXT_300);
    }

    public static byte[] deriveEncryptionKey(int dialect, byte[] sessionKey, byte[] preauthIntegrity) {
        return Smb3KeyDerivation.derive(sessionKey, dialect == 785 ? ENCLABEL_311 : ENCLABEL_300, dialect == 785 ? preauthIntegrity : ENCCONTEXT_300);
    }

    public static byte[] deriveDecryptionKey(int dialect, byte[] sessionKey, byte[] preauthIntegrity) {
        return Smb3KeyDerivation.derive(sessionKey, dialect == 785 ? DECLABEL_311 : DECLABEL_300, dialect == 785 ? preauthIntegrity : DECCONTEXT_300);
    }

    private static byte[] derive(byte[] sessionKey, byte[] label, byte[] context) {
        KDFCounterBytesGenerator gen = new KDFCounterBytesGenerator(new HMac(new SHA256Digest()));
        int r = 32;
        byte[] suffix = new byte[label.length + context.length + 5];
        System.arraycopy(label, 0, suffix, 0, label.length);
        System.arraycopy(context, 0, suffix, label.length + 1, context.length);
        suffix[suffix.length - 1] = -128;
        KDFCounterParameters param = new KDFCounterParameters(sessionKey, null, suffix, r);
        gen.init(param);
        byte[] derived = new byte[16];
        gen.generateBytes(derived, 0, 16);
        return derived;
    }

    private static byte[] toCBytes(String string) {
        byte[] data = new byte[string.length() + 1];
        System.arraycopy(string.getBytes(StandardCharsets.US_ASCII), 0, data, 0, string.length());
        return data;
    }
}

