/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.net;

import jcifs.Configuration;
import jcifs.internal.smb1.trans.SmbComTransactionResponse;
import jcifs.internal.util.SMBUtil;
import jcifs.smb.FileEntry;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetServerEnum2Response
extends SmbComTransactionResponse {
    private static final Logger log = LoggerFactory.getLogger(NetServerEnum2Response.class);
    private int converter;
    private int totalAvailableEntries;
    private String lastName;

    public NetServerEnum2Response(Configuration config) {
        super(config);
    }

    public final String getLastName() {
        return this.lastName;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        this.setStatus(SMBUtil.readInt2(buffer, bufferIndex));
        this.converter = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.setNumEntries(SMBUtil.readInt2(buffer, bufferIndex += 2));
        this.totalAvailableEntries = SMBUtil.readInt2(buffer, bufferIndex += 2);
        return (bufferIndex += 2) - start;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        ServerInfo1 e = null;
        FileEntry[] results = new ServerInfo1[this.getNumEntries()];
        for (int i = 0; i < this.getNumEntries(); ++i) {
            e = new ServerInfo1();
            results[i] = e;
            e.name = this.readString(buffer, bufferIndex, 16, false);
            bufferIndex += 16;
            e.versionMajor = buffer[bufferIndex++] & 0xFF;
            e.versionMinor = buffer[bufferIndex++] & 0xFF;
            e.type = SMBUtil.readInt4(buffer, bufferIndex);
            int off = SMBUtil.readInt4(buffer, bufferIndex += 4);
            bufferIndex += 4;
            off = (off & 0xFFFF) - this.converter;
            off = start + off;
            e.commentOrMasterBrowser = this.readString(buffer, off, 48, false);
            if (!log.isTraceEnabled()) continue;
            log.trace(e.toString());
        }
        this.setResults(results);
        this.lastName = e == null ? null : e.name;
        return bufferIndex - start;
    }

    @Override
    public String toString() {
        return new String("NetServerEnum2Response[" + super.toString() + ",status=" + this.getStatus() + ",converter=" + this.converter + ",entriesReturned=" + this.getNumEntries() + ",totalAvailableEntries=" + this.totalAvailableEntries + ",lastName=" + this.lastName + "]");
    }

    class ServerInfo1
    implements FileEntry {
        String name;
        int versionMajor;
        int versionMinor;
        int type;
        String commentOrMasterBrowser;

        ServerInfo1() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getType() {
            return (this.type & Integer.MIN_VALUE) != 0 ? 2 : 4;
        }

        @Override
        public int getAttributes() {
            return 17;
        }

        @Override
        public int getFileIndex() {
            return 0;
        }

        @Override
        public long createTime() {
            return 0L;
        }

        @Override
        public long lastModified() {
            return 0L;
        }

        @Override
        public long lastAccess() {
            return 0L;
        }

        @Override
        public long length() {
            return 0L;
        }

        public String toString() {
            return new String("ServerInfo1[name=" + this.name + ",versionMajor=" + this.versionMajor + ",versionMinor=" + this.versionMinor + ",type=0x" + Hexdump.toHexString(this.type, 8) + ",commentOrMasterBrowser=" + this.commentOrMasterBrowser + "]");
        }
    }
}

