/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1;

import jcifs.Configuration;
import jcifs.RuntimeCIFSException;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.smb1.com.SmbComNTCreateAndXResponse;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AndXServerMessageBlock
extends ServerMessageBlock {
    private static final Logger log = LoggerFactory.getLogger(AndXServerMessageBlock.class);
    private static final int ANDX_COMMAND_OFFSET = 1;
    private static final int ANDX_RESERVED_OFFSET = 2;
    private static final int ANDX_OFFSET_OFFSET = 3;
    private byte andxCommand = (byte)-1;
    private int andxOffset = 0;
    private ServerMessageBlock andx;

    protected AndXServerMessageBlock(Configuration config, byte command, String name, ServerMessageBlock andx) {
        super(config, command, name);
        this.andx = andx;
        if (andx != null) {
            this.andxCommand = (byte)andx.getCommand();
        }
    }

    protected AndXServerMessageBlock(Configuration config, byte command) {
        this(config, command, (ServerMessageBlock)null);
    }

    protected AndXServerMessageBlock(Configuration config, byte command, ServerMessageBlock andx) {
        super(config, command);
        this.andx = andx;
        if (andx != null) {
            this.andxCommand = (byte)andx.getCommand();
        }
    }

    protected AndXServerMessageBlock(Configuration config) {
        this(config, null);
    }

    protected AndXServerMessageBlock(Configuration config, ServerMessageBlock andx) {
        super(config);
        this.andx = andx;
        if (andx != null) {
            this.andxCommand = (byte)andx.getCommand();
        }
    }

    public final ServerMessageBlock getAndx() {
        return this.andx;
    }

    @Override
    public ServerMessageBlock getNext() {
        return this.andx;
    }

    @Override
    public ServerMessageBlock getNextResponse() {
        return this.andx;
    }

    protected int getBatchLimit(Configuration cfg, byte cmd) {
        return 0;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = this.headerStart = dstIndex;
        dstIndex += this.writeHeaderWireFormat(dst, dstIndex);
        dstIndex += this.writeAndXWireFormat(dst, dstIndex);
        this.length = dstIndex - start;
        if (this.digest != null) {
            this.digest.sign(dst, this.headerStart, this.length, this, this.getResponse());
        }
        return this.length;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int len;
        int start = this.headerStart = bufferIndex;
        bufferIndex += this.readHeaderWireFormat(buffer, bufferIndex);
        bufferIndex += this.readAndXWireFormat(buffer, bufferIndex);
        this.length = len = bufferIndex - start;
        if (this.isRetainPayload()) {
            byte[] payload = new byte[len];
            System.arraycopy(buffer, 4, payload, 0, len);
            this.setRawPayload(payload);
        }
        if (!this.verifySignature(buffer, 4, len)) {
            throw new SMBProtocolDecodingException("Signature verification failed for " + this.getClass().getName());
        }
        return len;
    }

    protected int writeAndXWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        this.wordCount = this.writeParameterWordsWireFormat(dst, start + 3 + 2);
        this.wordCount += 4;
        this.wordCount /= 2;
        dst[start] = (byte)(this.wordCount & 0xFF);
        this.byteCount = this.writeBytesWireFormat(dst, (dstIndex += this.wordCount + 1) + 2);
        dst[dstIndex++] = (byte)(this.byteCount & 0xFF);
        dst[dstIndex++] = (byte)(this.byteCount >> 8 & 0xFF);
        dstIndex += this.byteCount;
        if (this.andx == null || this.getConfig().isUseBatching() || this.batchLevel >= this.getBatchLimit(this.getConfig(), (byte)this.andx.getCommand())) {
            this.andxCommand = (byte)-1;
            this.andx = null;
            dst[start + 1] = -1;
            dst[start + 2] = 0;
            dst[start + 3] = -34;
            dst[start + 3 + 1] = -34;
            return dstIndex - start;
        }
        this.andx.batchLevel = this.batchLevel + 1;
        dst[start + 1] = this.andxCommand;
        dst[start + 2] = 0;
        this.andxOffset = dstIndex - this.headerStart;
        SMBUtil.writeInt2(this.andxOffset, dst, start + 3);
        this.andx.setUseUnicode(this.isUseUnicode());
        if (this.andx instanceof AndXServerMessageBlock) {
            this.andx.uid = this.uid;
            dstIndex += ((AndXServerMessageBlock)this.andx).writeAndXWireFormat(dst, dstIndex);
        } else {
            int andxStart = dstIndex;
            this.andx.wordCount = this.andx.writeParameterWordsWireFormat(dst, dstIndex);
            this.andx.wordCount /= 2;
            dst[andxStart] = (byte)(this.andx.wordCount & 0xFF);
            this.andx.byteCount = this.andx.writeBytesWireFormat(dst, (dstIndex += this.andx.wordCount + 1) + 2);
            dst[dstIndex++] = (byte)(this.andx.byteCount & 0xFF);
            dst[dstIndex++] = (byte)(this.andx.byteCount >> 8 & 0xFF);
            dstIndex += this.andx.byteCount;
        }
        return dstIndex - start;
    }

    protected int readAndXWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        this.wordCount = buffer[bufferIndex++];
        if (this.wordCount != 0) {
            this.andxCommand = buffer[bufferIndex];
            this.andxOffset = SMBUtil.readInt2(buffer, bufferIndex + 2);
            if (this.andxOffset == 0) {
                this.andxCommand = (byte)-1;
            }
            if (this.wordCount > 2) {
                this.readParameterWordsWireFormat(buffer, bufferIndex + 4);
                if (this.getCommand() == -94 && ((SmbComNTCreateAndXResponse)this).isExtended() && ((SmbComNTCreateAndXResponse)this).getFileType() != 1) {
                    this.wordCount += 8;
                }
            }
            bufferIndex = start + 1 + this.wordCount * 2;
        }
        this.byteCount = SMBUtil.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        if (this.byteCount != 0) {
            int n = this.readBytesWireFormat(buffer, bufferIndex);
            if (n != this.byteCount && log.isTraceEnabled()) {
                log.trace("Short read, have " + n + ", want " + this.byteCount);
            }
            bufferIndex += this.byteCount;
        }
        if (this.errorCode != 0 || this.andxCommand == -1) {
            this.andxCommand = (byte)-1;
            this.andx = null;
        } else {
            if (this.andx == null) {
                this.andxCommand = (byte)-1;
                throw new RuntimeCIFSException("no andx command supplied with response");
            }
            bufferIndex = this.headerStart + this.andxOffset;
            this.andx.headerStart = this.headerStart;
            this.andx.setCommand(this.andxCommand);
            this.andx.setErrorCode(this.getErrorCode());
            this.andx.setFlags(this.getFlags());
            this.andx.setFlags2(this.getFlags2());
            this.andx.setTid(this.getTid());
            this.andx.setPid(this.getPid());
            this.andx.setUid(this.getUid());
            this.andx.setMid(this.getMid());
            this.andx.setUseUnicode(this.isUseUnicode());
            if (this.andx instanceof AndXServerMessageBlock) {
                bufferIndex += ((AndXServerMessageBlock)this.andx).readAndXWireFormat(buffer, bufferIndex);
            } else {
                buffer[bufferIndex++] = (byte)(this.andx.wordCount & 0xFF);
                if (this.andx.wordCount != 0 && this.andx.wordCount > 2) {
                    bufferIndex += this.andx.readParameterWordsWireFormat(buffer, bufferIndex);
                }
                this.andx.byteCount = SMBUtil.readInt2(buffer, bufferIndex);
                bufferIndex += 2;
                if (this.andx.byteCount != 0) {
                    this.andx.readBytesWireFormat(buffer, bufferIndex);
                    bufferIndex += this.andx.byteCount;
                }
            }
            this.andx.received();
        }
        return bufferIndex - start;
    }

    @Override
    public String toString() {
        return new String(super.toString() + ",andxCommand=0x" + Hexdump.toHexString(this.andxCommand, 2) + ",andxOffset=" + this.andxOffset);
    }
}

