/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import jcifs.CIFSContext;
import jcifs.RuntimeCIFSException;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import org.opennms.shaded.org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NtlmHttpURLConnection
extends HttpURLConnection {
    private static final Logger log = LoggerFactory.getLogger(NtlmHttpURLConnection.class);
    private static final int MAX_REDIRECTS = Integer.parseInt(System.getProperty("http.maxRedirects", "20"));
    private HttpURLConnection connection;
    private Map<String, List<String>> requestProperties;
    private Map<String, List<String>> headerFields;
    private ByteArrayOutputStream cachedOutput;
    private String authProperty;
    private String authMethod;
    private boolean handshakeComplete;
    private CIFSContext transportContext;

    public NtlmHttpURLConnection(HttpURLConnection connection, CIFSContext tc) {
        super(connection.getURL());
        this.connection = connection;
        this.transportContext = tc;
        this.requestProperties = new HashMap<String, List<String>>();
        this.copySettings();
    }

    private final void copySettings() {
        try {
            this.setRequestMethod(this.connection.getRequestMethod());
        }
        catch (ProtocolException e) {
            throw new RuntimeCIFSException("Failed to set request method", e);
        }
        this.headerFields = null;
        for (Map.Entry<String, List<String>> property : this.connection.getRequestProperties().entrySet()) {
            String key = property.getKey();
            StringBuffer value = new StringBuffer();
            Iterator<String> values = property.getValue().iterator();
            while (values.hasNext()) {
                value.append(values.next());
                if (!values.hasNext()) continue;
                value.append(", ");
            }
            this.setRequestProperty(key, value.toString());
        }
        this.setAllowUserInteraction(this.connection.getAllowUserInteraction());
        this.setDoInput(this.connection.getDoInput());
        this.setDoOutput(this.connection.getDoOutput());
        this.setIfModifiedSince(this.connection.getIfModifiedSince());
        this.setUseCaches(this.connection.getUseCaches());
        this.setReadTimeout(this.connection.getReadTimeout());
        this.setConnectTimeout(this.connection.getConnectTimeout());
        this.setInstanceFollowRedirects(this.connection.getInstanceFollowRedirects());
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connection.connect();
        this.connected = true;
    }

    private void handshake() {
        if (this.handshakeComplete) {
            return;
        }
        try {
            this.doHandshake();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeCIFSException("NTLM handshake failed", e);
        }
        this.handshakeComplete = true;
    }

    @Override
    public URL getURL() {
        return this.connection.getURL();
    }

    @Override
    public int getContentLength() {
        this.handshake();
        return this.connection.getContentLength();
    }

    @Override
    public String getContentType() {
        this.handshake();
        return this.connection.getContentType();
    }

    @Override
    public String getContentEncoding() {
        this.handshake();
        return this.connection.getContentEncoding();
    }

    @Override
    public long getExpiration() {
        this.handshake();
        return this.connection.getExpiration();
    }

    @Override
    public long getDate() {
        this.handshake();
        return this.connection.getDate();
    }

    @Override
    public long getLastModified() {
        this.handshake();
        return this.connection.getLastModified();
    }

    @Override
    public String getHeaderField(String header) {
        this.handshake();
        return this.connection.getHeaderField(header);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<String>> getHeaderFields0() {
        if (this.headerFields != null) {
            return this.headerFields;
        }
        HashMap map = new HashMap();
        String key = this.connection.getHeaderFieldKey(0);
        String value = this.connection.getHeaderField(0);
        int i = 1;
        while (key != null || value != null) {
            void var5_6;
            List list = (List)map.get(key);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                map.put(key, arrayList);
            }
            var5_6.add(value);
            key = this.connection.getHeaderFieldKey(i);
            value = this.connection.getHeaderField(i);
            ++i;
        }
        for (Map.Entry entry : map.entrySet()) {
            entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
        }
        this.headerFields = Collections.unmodifiableMap(map);
        return this.headerFields;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        if (this.headerFields != null) {
            return this.headerFields;
        }
        this.handshake();
        return this.getHeaderFields0();
    }

    @Override
    public int getHeaderFieldInt(String header, int def) {
        this.handshake();
        return this.connection.getHeaderFieldInt(header, def);
    }

    @Override
    public long getHeaderFieldDate(String header, long def) {
        this.handshake();
        return this.connection.getHeaderFieldDate(header, def);
    }

    @Override
    public String getHeaderFieldKey(int index) {
        this.handshake();
        return this.connection.getHeaderFieldKey(index);
    }

    @Override
    public String getHeaderField(int index) {
        this.handshake();
        return this.connection.getHeaderField(index);
    }

    @Override
    public Object getContent() throws IOException {
        this.handshake();
        return this.connection.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        this.handshake();
        return this.connection.getContent(classes);
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.connection.getPermission();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.handshake();
        return this.connection.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.connect();
        OutputStream output = this.connection.getOutputStream();
        this.cachedOutput = new ByteArrayOutputStream();
        return new CacheStream(output, this.cachedOutput);
    }

    @Override
    public String toString() {
        return this.connection.toString();
    }

    @Override
    public void setDoInput(boolean doInput) {
        this.connection.setDoInput(doInput);
        this.doInput = doInput;
    }

    @Override
    public boolean getDoInput() {
        return this.connection.getDoInput();
    }

    @Override
    public void setDoOutput(boolean doOutput) {
        this.connection.setDoOutput(doOutput);
        this.doOutput = doOutput;
    }

    @Override
    public boolean getDoOutput() {
        return this.connection.getDoOutput();
    }

    @Override
    public void setAllowUserInteraction(boolean allowUserInteraction) {
        this.connection.setAllowUserInteraction(allowUserInteraction);
        this.allowUserInteraction = allowUserInteraction;
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.connection.getAllowUserInteraction();
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.connection.setUseCaches(useCaches);
        this.useCaches = useCaches;
    }

    @Override
    public boolean getUseCaches() {
        return this.connection.getUseCaches();
    }

    @Override
    public void setIfModifiedSince(long ifModifiedSince) {
        this.connection.setIfModifiedSince(ifModifiedSince);
        this.ifModifiedSince = ifModifiedSince;
    }

    @Override
    public long getIfModifiedSince() {
        return this.connection.getIfModifiedSince();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.connection.getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultUseCaches) {
        this.connection.setDefaultUseCaches(defaultUseCaches);
    }

    @Override
    public int getConnectTimeout() {
        return this.connection.getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.connection.setConnectTimeout(timeout);
    }

    @Override
    public int getReadTimeout() {
        return this.connection.getReadTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.connection.setReadTimeout(timeout);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        boolean found = false;
        for (Map.Entry<String, List<String>> entry : this.requestProperties.entrySet()) {
            if (!key.equalsIgnoreCase(entry.getKey())) continue;
            entry.setValue(values);
            found = true;
            break;
        }
        if (!found) {
            this.requestProperties.put(key, values);
        }
        this.connection.setRequestProperty(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        List<Object> values = null;
        for (Map.Entry<String, List<String>> entry : this.requestProperties.entrySet()) {
            if (!key.equalsIgnoreCase(entry.getKey())) continue;
            values = entry.getValue();
            values.add(value);
            break;
        }
        if (values == null) {
            values = new ArrayList<String>();
            values.add(value);
            this.requestProperties.put(key, values);
        }
        StringBuffer buffer = new StringBuffer();
        Iterator propertyValues = values.iterator();
        while (propertyValues.hasNext()) {
            buffer.append((String)propertyValues.next());
            if (!propertyValues.hasNext()) continue;
            buffer.append(", ");
        }
        this.connection.setRequestProperty(key, buffer.toString());
    }

    @Override
    public String getRequestProperty(String key) {
        return this.connection.getRequestProperty(key);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.requestProperties.entrySet()) {
            map.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void setInstanceFollowRedirects(boolean instanceFollowRedirects) {
        this.connection.setInstanceFollowRedirects(instanceFollowRedirects);
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.connection.getInstanceFollowRedirects();
    }

    @Override
    public void setRequestMethod(String requestMethod) throws ProtocolException {
        this.connection.setRequestMethod(requestMethod);
        this.method = requestMethod;
    }

    @Override
    public String getRequestMethod() {
        return this.connection.getRequestMethod();
    }

    @Override
    public int getResponseCode() throws IOException {
        this.handshake();
        return this.connection.getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        this.handshake();
        return this.connection.getResponseMessage();
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        this.handshakeComplete = false;
        this.connected = false;
    }

    @Override
    public boolean usingProxy() {
        return this.connection.usingProxy();
    }

    @Override
    public InputStream getErrorStream() {
        this.handshake();
        return this.connection.getErrorStream();
    }

    private int parseResponseCode() throws IOException {
        try {
            String response = this.connection.getHeaderField(0);
            int index = response.indexOf(32);
            while (response.charAt(index) == ' ') {
                ++index;
            }
            return Integer.parseInt(response.substring(index, index + 3));
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private void doHandshake() throws IOException, GeneralSecurityException {
        this.connect();
        try {
            int response = this.parseResponseCode();
            if (response != 401 && response != 407) {
                return;
            }
            NtlmMessage type1 = this.attemptNegotiation(response);
            if (type1 == null) {
                return;
            }
            int attempt = 0;
            while (attempt < MAX_REDIRECTS) {
                this.connection.setRequestProperty(this.authProperty, this.authMethod + ' ' + Base64.toBase64String(type1.toByteArray()));
                this.connection.connect();
                response = this.parseResponseCode();
                if (response != 401 && response != 407) {
                    return;
                }
                NtlmMessage type3 = this.attemptNegotiation(response);
                if (type3 == null) {
                    return;
                }
                this.connection.setRequestProperty(this.authProperty, this.authMethod + ' ' + Base64.toBase64String(type3.toByteArray()));
                this.connection.connect();
                if (this.cachedOutput != null && this.doOutput) {
                    OutputStream output = this.connection.getOutputStream();
                    this.cachedOutput.writeTo(output);
                    output.flush();
                }
                if ((response = this.parseResponseCode()) != 401 && response != 407) {
                    return;
                }
                if (!this.allowUserInteraction || ++attempt >= MAX_REDIRECTS) break;
                this.reconnect();
            }
            throw new IOException("Unable to negotiate NTLM authentication.");
        }
        finally {
            this.cachedOutput = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private NtlmMessage attemptNegotiation(int response) throws IOException, GeneralSecurityException {
        block48: {
            block49: {
                block50: {
                    block45: {
                        block46: {
                            block47: {
                                block51: {
                                    block42: {
                                        block43: {
                                            block44: {
                                                block39: {
                                                    block40: {
                                                        block41: {
                                                            this.authProperty = null;
                                                            this.authMethod = null;
                                                            errorStream = this.connection.getErrorStream();
                                                            var3_3 = null;
                                                            if (errorStream != null && errorStream.available() != 0) {
                                                                buf = new byte[1024];
                                                                while (errorStream.read(buf, 0, 1024) != -1) {
                                                                }
                                                            }
                                                            if (response == 401) {
                                                                authHeader = "WWW-Authenticate";
                                                                this.authProperty = "Authorization";
                                                            } else {
                                                                authHeader = "Proxy-Authenticate";
                                                                this.authProperty = "Proxy-Authorization";
                                                            }
                                                            authorization = null;
                                                            methods = this.getHeaderFields0().get(authHeader);
                                                            if (methods != null) break block39;
                                                            var7_8 = null;
                                                            if (errorStream == null) break block40;
                                                            if (var3_3 == null) break block41;
                                                            try {
                                                                errorStream.close();
                                                            }
                                                            catch (Throwable var8_10) {
                                                                var3_3.addSuppressed(var8_10);
                                                            }
                                                            break block40;
                                                        }
                                                        errorStream.close();
                                                    }
                                                    return var7_8;
                                                }
                                                for (String currentAuthMethod : methods) {
                                                    if (currentAuthMethod.startsWith("NTLM")) {
                                                        if (currentAuthMethod.length() == 4) {
                                                            this.authMethod = "NTLM";
                                                            break;
                                                        }
                                                        if (currentAuthMethod.indexOf(32) != 4) continue;
                                                        this.authMethod = "NTLM";
                                                        authorization = currentAuthMethod.substring(5).trim();
                                                        break;
                                                    }
                                                    if (!currentAuthMethod.startsWith("Negotiate")) continue;
                                                    if (currentAuthMethod.length() == 9) {
                                                        this.authMethod = "Negotiate";
                                                        break;
                                                    }
                                                    if (currentAuthMethod.indexOf(32) != 9) continue;
                                                    this.authMethod = "Negotiate";
                                                    authorization = currentAuthMethod.substring(10).trim();
                                                    break;
                                                }
                                                if (this.authMethod != null) break block42;
                                                currentAuthMethod = null;
                                                if (errorStream == null) break block43;
                                                if (var3_3 == null) break block44;
                                                try {
                                                    errorStream.close();
                                                }
                                                catch (Throwable var9_12) {
                                                    var3_3.addSuppressed(var9_12);
                                                }
                                                break block43;
                                            }
                                            errorStream.close();
                                        }
                                        return currentAuthMethod;
                                    }
                                    message = authorization != null ? new Type2Message(Base64.decode(authorization)) : null;
                                    this.reconnect();
                                    if (message != null) break block51;
                                    message = new Type1Message(this.transportContext);
                                    if (this.transportContext.getConfig().getLanManCompatibility() > 2) {
                                        message.setFlag(4, true);
                                    }
                                    ** GOTO lbl136
                                }
                                if (!(this.transportContext.getCredentials() instanceof NtlmPasswordAuthentication)) ** GOTO lbl136
                                npa = (NtlmPasswordAuthentication)this.transportContext.getCredentials();
                                domain = npa.getUserDomain();
                                user = npa.isAnonymous() == false ? npa.getUsername() : null;
                                password = npa.getPassword();
                                userInfo = this.url.getUserInfo();
                                if (userInfo != null) {
                                    index = (userInfo = URLDecoder.decode(userInfo, "UTF-8")).indexOf(58);
                                    v0 = user = index != -1 ? userInfo.substring(0, index) : userInfo;
                                    if (index != -1) {
                                        password = userInfo.substring(index + 1);
                                    }
                                    if ((index = user.indexOf(92)) == -1) {
                                        index = user.indexOf(47);
                                    }
                                    domain = index != -1 ? user.substring(0, index) : domain;
                                    v1 = user = index != -1 ? user.substring(index + 1) : user;
                                }
                                if (user != null) ** GOTO lbl134
                                if (this.allowUserInteraction) break block45;
                                index = null;
                                if (errorStream == null) break block46;
                                if (var3_3 == null) break block47;
                                try {
                                    errorStream.close();
                                }
                                catch (Throwable var15_24) {
                                    var3_3.addSuppressed(var15_24);
                                }
                                break block46;
                            }
                            errorStream.close();
                        }
                        return index;
                    }
                    u = this.getURL();
                    protocol = u.getProtocol();
                    port = u.getPort();
                    if (port == -1) {
                        v2 = port = "https".equalsIgnoreCase(protocol) != false ? 443 : 80;
                    }
                    if ((auth = Authenticator.requestPasswordAuthentication(null, port, protocol, "", this.authMethod)) != null) break block48;
                    var18_28 = null;
                    if (errorStream == null) break block49;
                    if (var3_3 == null) break block50;
                    try {
                        errorStream.close();
                    }
                    catch (Throwable var19_29) {
                        var3_3.addSuppressed(var19_29);
                    }
                    break block49;
                }
                errorStream.close();
            }
            return var18_28;
        }
        try {
            try {
                user = auth.getUserName();
                password = new String(auth.getPassword());
            }
            catch (Exception ex) {
                NtlmHttpURLConnection.log.debug("Interactive authentication failed", (Throwable)ex);
            }
lbl134:
            // 3 sources

            type2 = (Type2Message)message;
            message = new Type3Message(this.transportContext, type2, null, password, domain, user, this.transportContext.getNameServiceClient().getLocalHost().getHostName(), 0);
lbl136:
            // 3 sources

            var9_13 = message;
            return var9_13;
        }
        catch (Throwable var4_5) {
            var3_3 = var4_5;
            throw var4_5;
        }
        catch (Throwable var20_30) {
            throw var20_30;
        }
        finally {
            if (errorStream != null) {
                if (var3_3 != null) {
                    try {
                        errorStream.close();
                    }
                    catch (Throwable var10_15) {
                        var3_3.addSuppressed(var10_15);
                    }
                } else {
                    errorStream.close();
                }
            }
        }
    }

    private void reconnect() throws IOException {
        int readTimeout = this.getReadTimeout();
        int connectTimeout = this.getConnectTimeout();
        HostnameVerifier hv = null;
        SSLSocketFactory ssf = null;
        if (this.connection instanceof HttpsURLConnection) {
            hv = ((HttpsURLConnection)this.connection).getHostnameVerifier();
            ssf = ((HttpsURLConnection)this.connection).getSSLSocketFactory();
        }
        this.connection = (HttpURLConnection)this.connection.getURL().openConnection();
        if (this.connection instanceof HttpsURLConnection) {
            if (hv != null) {
                ((HttpsURLConnection)this.connection).setHostnameVerifier(hv);
            }
            if (ssf != null) {
                ((HttpsURLConnection)this.connection).setSSLSocketFactory(ssf);
            }
        }
        this.connection.setRequestMethod(this.method);
        this.headerFields = null;
        for (Map.Entry<String, List<String>> property : this.requestProperties.entrySet()) {
            String key = property.getKey();
            StringBuffer value = new StringBuffer();
            Iterator<String> values = property.getValue().iterator();
            while (values.hasNext()) {
                value.append(values.next());
                if (!values.hasNext()) continue;
                value.append(", ");
            }
            this.connection.setRequestProperty(key, value.toString());
        }
        this.connection.setAllowUserInteraction(this.allowUserInteraction);
        this.connection.setDoInput(this.doInput);
        this.connection.setDoOutput(this.doOutput);
        this.connection.setIfModifiedSince(this.ifModifiedSince);
        this.connection.setInstanceFollowRedirects(this.instanceFollowRedirects);
        this.connection.setUseCaches(this.useCaches);
        this.connection.setReadTimeout(readTimeout);
        this.connection.setConnectTimeout(connectTimeout);
    }

    private static class CacheStream
    extends OutputStream {
        private final OutputStream stream;
        private final OutputStream collector;

        public CacheStream(OutputStream stream, OutputStream collector) {
            this.stream = stream;
            this.collector = collector;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            this.collector.close();
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
            this.collector.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.stream.write(b);
            this.collector.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
            this.collector.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(b);
            this.collector.write(b);
        }
    }
}

