/*
 * Decompiled with CFR 0.152.
 */
package jcifs.context;

import java.net.MalformedURLException;
import java.net.URLStreamHandler;
import jcifs.BufferCache;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.Credentials;
import jcifs.DfsResolver;
import jcifs.NameServiceClient;
import jcifs.SidResolver;
import jcifs.SmbPipeResource;
import jcifs.SmbResource;
import jcifs.SmbTransportPool;
import jcifs.context.AbstractCIFSContext;
import jcifs.netbios.NameServiceClientImpl;
import jcifs.smb.BufferCacheImpl;
import jcifs.smb.CredentialsInternal;
import jcifs.smb.DfsImpl;
import jcifs.smb.Handler;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SIDCacheImpl;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.SmbTransportPoolImpl;

public class BaseContext
extends AbstractCIFSContext {
    private final Configuration config;
    private final DfsResolver dfs;
    private final SidResolver sidResolver;
    private final Handler urlHandler;
    private final NameServiceClient nameServiceClient;
    private final BufferCache bufferCache;
    private final SmbTransportPool transportPool;
    private final CredentialsInternal defaultCredentials;

    public BaseContext(Configuration config) {
        this.config = config;
        this.dfs = new DfsImpl(this);
        this.sidResolver = new SIDCacheImpl(this);
        this.urlHandler = new Handler(this);
        this.nameServiceClient = new NameServiceClientImpl(this);
        this.bufferCache = new BufferCacheImpl(this.config);
        this.transportPool = new SmbTransportPoolImpl();
        this.defaultCredentials = new NtlmPasswordAuthenticator();
    }

    @Override
    public SmbResource get(String url) throws CIFSException {
        try {
            return new SmbFile(url, (CIFSContext)this);
        }
        catch (MalformedURLException e) {
            throw new CIFSException("Invalid URL " + url, e);
        }
    }

    @Override
    public SmbPipeResource getPipe(String url, int pipeType) throws CIFSException {
        try {
            return new SmbNamedPipe(url, pipeType, this);
        }
        catch (MalformedURLException e) {
            throw new CIFSException("Invalid URL " + url, e);
        }
    }

    @Override
    public SmbTransportPool getTransportPool() {
        return this.transportPool;
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public DfsResolver getDfs() {
        return this.dfs;
    }

    @Override
    public NameServiceClient getNameServiceClient() {
        return this.nameServiceClient;
    }

    @Override
    public BufferCache getBufferCache() {
        return this.bufferCache;
    }

    @Override
    public URLStreamHandler getUrlHandler() {
        return this.urlHandler;
    }

    @Override
    public SidResolver getSIDResolver() {
        return this.sidResolver;
    }

    @Override
    protected Credentials getDefaultCredentials() {
        return this.defaultCredentials;
    }

    @Override
    public boolean close() throws CIFSException {
        boolean inUse = super.close();
        return inUse |= this.transportPool.close();
    }
}

