/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.bridge.proxy.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opennms.container.web.bridge.api.RestEndpointRegistry;
import org.opennms.container.web.bridge.proxy.handlers.RequestHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RestRequestHandler
implements RequestHandler {
    private final BundleContext bundleContext;

    public RestRequestHandler(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    @Override
    public boolean canHandle(String requestedPath) {
        List<String> knownPatterns = this.getPatterns();
        for (String eachPattern : knownPatterns) {
            if (!requestedPath.startsWith(eachPattern)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getPatterns() {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(RestEndpointRegistry.class);
        if (serviceReference != null) {
            try {
                RestEndpointRegistry restEndpointRegistry = (RestEndpointRegistry)this.bundleContext.getService(serviceReference);
                List list = restEndpointRegistry.getRestEndpoints();
                return list;
            }
            finally {
                this.bundleContext.ungetService(serviceReference);
            }
        }
        return Collections.emptyList();
    }
}

