/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamingHelper {
    private static final Logger log = LoggerFactory.getLogger(NamingHelper.class);

    public static InitialContext getInitialContext(Properties props) throws NamingException {
        Properties hash = NamingHelper.getJndiProperties(props);
        log.info("JNDI InitialContext properties:" + hash);
        try {
            return ((Hashtable)hash).size() == 0 ? new InitialContext() : new InitialContext(hash);
        }
        catch (NamingException e) {
            log.error("Could not obtain initial context", (Throwable)e);
            throw e;
        }
    }

    public static void bind(Context ctx, String name, Object val) throws NamingException {
        try {
            log.trace("binding: " + name);
            ctx.rebind(name, val);
        }
        catch (Exception e) {
            Name n = ctx.getNameParser("").parse(name);
            while (n.size() > 1) {
                String ctxName = n.get(0);
                Context subctx = null;
                try {
                    log.trace("lookup: " + ctxName);
                    subctx = (Context)ctx.lookup(ctxName);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                if (subctx != null) {
                    log.debug("Found subcontext: " + ctxName);
                    ctx = subctx;
                } else {
                    log.info("Creating subcontext: " + ctxName);
                    ctx = ctx.createSubcontext(ctxName);
                }
                n = n.getSuffix(1);
            }
            log.trace("binding: " + n);
            ctx.rebind(n, val);
        }
        log.debug("Bound name: " + name);
    }

    public static Properties getJndiProperties(Properties properties) {
        HashSet<String> specialProps = new HashSet<String>();
        specialProps.add("hibernate.jndi.class");
        specialProps.add("hibernate.jndi.url");
        Iterator<Object> iter = properties.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            if (prop.indexOf("hibernate.jndi") <= -1 || specialProps.contains(prop)) continue;
            result.setProperty(prop.substring("hibernate.jndi".length() + 1), properties.getProperty(prop));
        }
        String jndiClass = properties.getProperty("hibernate.jndi.class");
        String jndiURL = properties.getProperty("hibernate.jndi.url");
        if (jndiClass != null) {
            result.put("java.naming.factory.initial", jndiClass);
        }
        if (jndiURL != null) {
            result.put("java.naming.provider.url", jndiURL);
        }
        return result;
    }

    private NamingHelper() {
    }
}

