/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.opennms.web.rest.model.v2.BridgeElementNodeDTO;
import org.opennms.web.rest.model.v2.BridgeLinkNodeDTO;
import org.opennms.web.rest.model.v2.CdpElementNodeDTO;
import org.opennms.web.rest.model.v2.CdpLinkNodeDTO;
import org.opennms.web.rest.model.v2.EnlinkdDTO;
import org.opennms.web.rest.model.v2.IsisElementNodeDTO;
import org.opennms.web.rest.model.v2.IsisLinkNodeDTO;
import org.opennms.web.rest.model.v2.LldpElementNodeDTO;
import org.opennms.web.rest.model.v2.LldpLinkNodeDTO;
import org.opennms.web.rest.model.v2.OspfElementNodeDTO;
import org.opennms.web.rest.model.v2.OspfLinkNodeDTO;

@Path(value="enlinkd")
public interface NodeLinkRestApi {
    @GET
    @Path(value="{node_criteria}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a node's all types of links", description="Get all types of links for a specific node", operationId="NodeLinkRestApiGetAllTypesOfLinks", tags={"Enlinkd"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=EnlinkdDTO.class))}), @ApiResponse(responseCode="404", description="Node not found", content={@Content})})
    public EnlinkdDTO getEnlinkd(@PathParam(value="node_criteria") String var1);

    @GET
    @Path(value="lldp_links/{node_criteria}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a node's LLDP Link", description="Get LLDP link for a specific node", operationId="NodeLinkRestApiGetNodeLLDPLinkByNodeId", tags={"Enlinkd"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(array=@ArraySchema(schema=@Schema(implementation=LldpLinkNodeDTO.class)))}), @ApiResponse(responseCode="404", description="Node not found", content={@Content})})
    public List<LldpLinkNodeDTO> getLldpLinks(@PathParam(value="node_criteria") String var1);

    @GET
    @Path(value="bridge_links/{node_criteria}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a node's bridge Link", description="Get bridge link for a specific node", operationId="NodeLinkRestApiGetNodeBridgeLinkByNodeId", tags={"Enlinkd"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(array=@ArraySchema(schema=@Schema(implementation=BridgeLinkNodeDTO.class)))}), @ApiResponse(responseCode="404", description="Node not found", content={@Content})})
    public List<BridgeLinkNodeDTO> getBridgeLinks(@PathParam(value="node_criteria") String var1);

    @GET
    @Path(value="cdp_links/{node_criteria}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a node's CDP Link", description="Get CDP link for a specific node", operationId="NodeLinkRestApiGetNodeCDPLinkByNodeId", tags={"Enlinkd"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(array=@ArraySchema(schema=@Schema(implementation=CdpLinkNodeDTO.class)))}), @ApiResponse(responseCode="404", description="Node not found", content={@Content})})
    public List<CdpLinkNodeDTO> getCdpLinks(@PathParam(value="node_criteria") String var1);

    @GET
    @Path(value="ospf_links/{node_criteria}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a node's OSPF Link", description="Get OSPF link for a specific node", operationId="NodeLinkRestApiGetNodeOSPFLinkByNodeId", tags={"Enlinkd"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(array=@ArraySchema(schema=@Schema(implementation=OspfLinkNodeDTO.class)))}), @ApiResponse(responseCode="404", description="Node not found", content={@Content})})
    public List<OspfLinkNodeDTO> getOspfLinks(@PathParam(value="node_criteria") String var1);

    @GET
    @Path(value="isis_links/{node_criteria}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a node's IS-IS Link", description="Get IS-IS link for a specific node", operationId="NodeLinkRestApiGetNodeISISLinkByNodeId", tags={"Enlinkd"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(array=@ArraySchema(schema=@Schema(implementation=IsisLinkNodeDTO.class)))}), @ApiResponse(responseCode="404", description="Node not found", content={@Content})})
    public List<IsisLinkNodeDTO> getIsisLinks(@PathParam(value="node_criteria") String var1);

    @GET
    @Path(value="lldp_elems/{node_criteria}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a node's LLDP element", description="Get LLDP element for a specific node", operationId="NodeLinkRestApiGetElementLLDPLinkByNodeId", tags={"Enlinkd"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=LldpElementNodeDTO.class))}), @ApiResponse(responseCode="204", description="No corresponding element found"), @ApiResponse(responseCode="404", description="Node not found", content={@Content})})
    public LldpElementNodeDTO getLldpElem(@PathParam(value="node_criteria") String var1);

    @GET
    @Path(value="bridge_elems/{node_criteria}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a node's bridge element", description="Get bridge element for a specific node", operationId="NodeLinkRestApiGetElementBridgeLinkByNodeId", tags={"Enlinkd"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(array=@ArraySchema(schema=@Schema(implementation=BridgeElementNodeDTO.class)))}), @ApiResponse(responseCode="404", description="Node not found", content={@Content})})
    public List<BridgeElementNodeDTO> getBridgeElem(@PathParam(value="node_criteria") String var1);

    @GET
    @Path(value="cdp_elems/{node_criteria}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a node's CDP element", description="Get CDP element for a specific node", operationId="NodeLinkRestApiGetElementCDPLinkByNodeId", tags={"Enlinkd"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=CdpElementNodeDTO.class))}), @ApiResponse(responseCode="204", description="No corresponding element found"), @ApiResponse(responseCode="404", description="Node not found", content={@Content})})
    public CdpElementNodeDTO getCdpElem(@PathParam(value="node_criteria") String var1);

    @GET
    @Path(value="ospf_elems/{node_criteria}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a node's OSPF element", description="Get OSPF element for a specific node", operationId="NodeLinkRestApiGetElementOSPFLinkByNodeId", tags={"Enlinkd"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=OspfElementNodeDTO.class))}), @ApiResponse(responseCode="204", description="No corresponding element found"), @ApiResponse(responseCode="404", description="Node not found", content={@Content})})
    public OspfElementNodeDTO getOspfElem(@PathParam(value="node_criteria") String var1);

    @GET
    @Path(value="isis_elems/{node_criteria}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a node's IS-IS element", description="Get IS-IS element for a specific node", operationId="NodeLinkRestApiGetElementISISLinkByNodeId", tags={"Enlinkd"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=IsisElementNodeDTO.class))}), @ApiResponse(responseCode="204", description="No corresponding element found"), @ApiResponse(responseCode="404", description="Node not found", content={@Content})})
    public IsisElementNodeDTO getIsisElem(@PathParam(value="node_criteria") String var1);
}

