/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="events")
@Tag(name="Events", description="Events API V2")
public interface EventRestApi {
    @GET
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    @Operation(summary="Get all events", description="Get all events", operationId="EventRestAPIGetAllEvents", tags={"Events"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful operation", content={@Content}), @ApiResponse(responseCode="204", description="No events found", content={@Content})})
    public Response get(@Context UriInfo var1, @Context SearchContext var2);

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    @Operation(summary="Get the events specified by the given ID", description="Get the events specified by the given ID", operationId="EventRestAPIGetEventById", tags={"Events"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful operation", content={@Content}), @ApiResponse(responseCode="204", description="No events found", content={@Content})})
    public Response get(@Context UriInfo var1, @PathParam(value="id") Long var2);

    @GET
    @Path(value="count")
    @Produces(value={"text/plain"})
    @Operation(summary="Get total count of events", description="Get total count of events", operationId="EventRestAPIGetEventsCount", tags={"Events"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful operation", content={@Content})})
    public Response getCount(@Context UriInfo var1, @Context SearchContext var2);

    @GET
    @Path(value="properties")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get event properties", description="Get event properties with a given query", operationId="EventRestAPIGetEventProperties", tags={"Events"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful operation", content={@Content}), @ApiResponse(responseCode="204", description="No events properties found", content={@Content})})
    public Response getProperties(@QueryParam(value="q") String var1);

    @GET
    @Path(value="properties/{propertyId}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get event properties specified by query and propertyId", description="Get event properties with a given query and propertyId", operationId="EventRestAPIGetPropertyByPropertyId", tags={"Events"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful operation", content={@Content}), @ApiResponse(responseCode="404", description="No events properties found", content={@Content})})
    public Response getPropertyValues(@PathParam(value="propertyId") String var1, @QueryParam(value="q") String var2, @QueryParam(value="limit") Integer var3);

    @POST
    @Path(value="{tiebreaker: $}")
    @Consumes(value={"application/json", "application/xml"})
    @Operation(summary="Publish a new event", description="Publish a new event", operationId="EventRestAPIPostTiebreaker")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Successful operation", content={@Content}), @ApiResponse(responseCode="500", description="Publish event error", content={@Content})})
    public Response create(@RequestBody Event var1);
}

