/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.snmpmetadata.SnmpMetadataBase;
import org.opennms.netmgt.model.snmpmetadata.SnmpMetadataObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="snmpmetadata")
@Transactional
@Tag(name="SnmpMetadata", description="SNMP metadata API")
public class SnmpMetadataRestService {
    @Autowired
    private NodeDao nodeDao;

    @GET
    @Path(value="{nodeCriteria}")
    @Produces(value={"application/xml", "application/json"})
    @Operation(summary="Get snmpmetadata by nodeId", description="Get snmpmetadata by nodeId", operationId="SnmpMetadataRestServiceGETSNMPMetaDataByNodId")
    public Response getSnmpMetadata(@PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.nodeDao.get(nodeCriteria);
        if (node == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        SnmpMetadataBase snmpMetadataBase = SnmpMetadataObject.fromOnmsMetadata((List)node.getMetaData(), (String)"snmp");
        return Response.ok((Object)snmpMetadataBase).build();
    }
}

