/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import joptsimple.internal.Strings;
import org.opennms.web.rest.support.newsfeed.NewsFeed;
import org.opennms.web.rest.support.newsfeed.NewsFeedProvider;
import org.opennms.web.rest.support.newsfeed.xml.NewsFeedXml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="newsfeed")
@Tag(name="Newsfeed", description="Newsfeed API")
public class NewsFeedRestService {
    private static final String DEFAULT_NEWS_FEED_URL = "https://www.opennms.com/feed/";
    private static final Logger LOG = LoggerFactory.getLogger(NewsFeedRestService.class);
    private String feedUrl;
    @Autowired
    private NewsFeedProvider newsFeedProvider;
    private final LoadingCache<String, String> cache;

    public NewsFeedRestService() {
        String newsFeedUrlProperty = System.getProperty("opennms.newsFeedPanel.url", "");
        this.feedUrl = !Strings.isNullOrEmpty((String)newsFeedUrlProperty) ? newsFeedUrlProperty : DEFAULT_NEWS_FEED_URL;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(100L).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String cacheKey) throws Exception {
                String body = "";
                try {
                    body = NewsFeedRestService.this.requestNewsFeed(NewsFeedRestService.this.feedUrl);
                }
                catch (Exception e) {
                    LOG.error("News Feed: Got exception requesting feed from {}: {}", (Object)NewsFeedRestService.this.feedUrl, (Object)e.getMessage());
                    throw e;
                }
                return body;
            }
        });
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Operation(summary="Get news feed", description="Get news feed", operationId="NewsFeedRestServiceGetNewsFeed")
    public Response getNewsFeed(@Context HttpServletRequest request) {
        try {
            String responseBody = (String)this.cache.get((Object)"newsfeed");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(responseBody.getBytes());
            NewsFeedXml.RssElement xRss = this.newsFeedProvider.parseXml(inputStream);
            NewsFeed newsFeed = this.newsFeedProvider.parseXmlToNewsFeed(xRss);
            return Response.ok((Object)newsFeed).build();
        }
        catch (Exception e) {
            LOG.error("News Feed: Got exception: {}", (Object)e.getMessage());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"Error building news feed.").build());
        }
    }

    private String requestNewsFeed(String feedUrl) throws Exception, IOException, InterruptedException {
        LOG.info("Requesting news feed from url {}.", (Object)feedUrl);
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(10L)).build();
        HttpRequest httpRequest = HttpRequest.newBuilder().GET().uri(URI.create(feedUrl)).setHeader("User-Agent", "OpenNMS NewsFeedRestService").build();
        HttpResponse<String> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            LOG.error("Received error response from news feed: {}.", (Object)response.statusCode());
            throw new Exception("Error response from news feed.");
        }
        String responseBody = response.body();
        LOG.info("Received news feed response.");
        return responseBody;
    }
}

