/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.dao.api.EventConfEventDao;
import org.opennms.netmgt.dao.api.EventConfSourceDao;
import org.opennms.netmgt.dao.support.EventConfServiceHelper;
import org.opennms.netmgt.model.EventConfEvent;
import org.opennms.netmgt.model.EventConfSource;
import org.opennms.netmgt.model.events.EnableDisableConfSourceEventsPayload;
import org.opennms.netmgt.model.events.EventConfSourceDeletePayload;
import org.opennms.netmgt.model.events.EventConfSourceMetadataDto;
import org.opennms.netmgt.model.events.EventConfSrcEnableDisablePayload;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.web.rest.v2.model.EventConfEventDeletePayload;
import org.opennms.web.rest.v2.model.EventConfEventEditRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EventConfPersistenceService {
    private static final Logger LOG = LoggerFactory.getLogger(EventConfPersistenceService.class);
    @Autowired
    private EventConfSourceDao eventConfSourceDao;
    @Autowired
    private EventConfEventDao eventConfEventDao;
    @Autowired
    private EventConfDao eventConfDao;
    private final ExecutorService eventConfExecutor = EventConfServiceHelper.createEventConfExecutor((String)"load-eventConf-%d");

    @PostConstruct
    public void init() {
        EventConfServiceHelper.reloadEventsFromDBAsync((EventConfEventDao)this.eventConfEventDao, (EventConfDao)this.eventConfDao, (ExecutorService)this.eventConfExecutor);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void persistEventConfFile(Events events, EventConfSourceMetadataDto eventConfSourceMetadataDto) {
        EventConfSource source = this.createOrUpdateSource(eventConfSourceMetadataDto);
        this.eventConfEventDao.deleteBySourceId(source.getId());
        this.saveEvents(source, events, eventConfSourceMetadataDto.getUsername(), eventConfSourceMetadataDto.getNow());
    }

    @Transactional
    public Long addEventConfSourceEvent(Long sourceId, String userName, Event event) {
        Date now = new Date();
        EventConfSource eventConfSource = this.eventConfSourceDao.get(sourceId);
        Long eventConfId = EventConfServiceHelper.saveEvent((EventConfEventDao)this.eventConfEventDao, (EventConfSource)eventConfSource, (Event)event, (String)userName, (Date)now);
        eventConfSource.setEventCount(Integer.valueOf(eventConfSource.getEventCount() + 1));
        this.eventConfSourceDao.saveOrUpdate(eventConfSource);
        return eventConfId;
    }

    public List<EventConfEvent> findEventConfByFilters(String uei, String vendor, String sourceName, int offset, int limit) {
        return this.eventConfEventDao.filterEventConf(uei, vendor, sourceName, offset, limit);
    }

    @Transactional
    public void updateSourceAndEventEnabled(EventConfSrcEnableDisablePayload eventConfSrcEnableDisablePayload) {
        this.eventConfSourceDao.updateEnabledFlag((Collection)eventConfSrcEnableDisablePayload.getSourceIds(), eventConfSrcEnableDisablePayload.getEnabled().booleanValue(), eventConfSrcEnableDisablePayload.getCascadeToEvents().booleanValue());
    }

    @Transactional
    public void deleteEventConfSources(EventConfSourceDeletePayload eventConfSourceDeletePayload) throws Exception {
        this.eventConfSourceDao.deleteBySourceIds(eventConfSourceDeletePayload.getSourceIds());
    }

    @Transactional
    public void enableDisableConfSourcesEvents(Long sourceId, EnableDisableConfSourceEventsPayload enableDisableConfSourceEventsPayload) {
        this.eventConfEventDao.updateEventEnabledFlag(sourceId, enableDisableConfSourceEventsPayload.getEventsIds(), enableDisableConfSourceEventsPayload.isEnable());
    }

    @Transactional
    public void updateEventConfEvent(Long sourceId, Long eventId, EventConfEventEditRequest payload) {
        try {
            EventConfEvent eventConfEvent = this.eventConfEventDao.findBySourceIdAndEventId(sourceId, eventId);
            if (eventConfEvent == null) {
                throw new EntityNotFoundException(String.format("EventConfEvent not found for eventId=%d", eventId));
            }
            eventConfEvent.setUei(payload.getEvent().getUei());
            eventConfEvent.setEventLabel(payload.getEvent().getEventLabel());
            eventConfEvent.setDescription(payload.getEvent().getDescr());
            eventConfEvent.setEnabled(payload.getEnabled());
            eventConfEvent.setXmlContent(JaxbUtils.marshal((Object)payload.getEvent()));
            eventConfEvent.setLastModified(new Date());
            eventConfEvent.setSeverity(EventConfServiceHelper.getValidSeverity((String)payload.getEvent().getSeverity()));
            this.eventConfEventDao.saveOrUpdate((Object)eventConfEvent);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update EventConfEvent XML for eventId=" + eventId, e);
        }
    }

    @Transactional
    public Long createEventConfSource(EventConfSource eventConfSource) {
        return (Long)this.eventConfSourceDao.save((Object)eventConfSource);
    }

    private EventConfSource createOrUpdateSource(EventConfSourceMetadataDto eventConfSourceMetadataDto) {
        EventConfSource source = this.eventConfSourceDao.findByName(eventConfSourceMetadataDto.getFilename());
        if (source == null) {
            source = new EventConfSource();
            source.setCreatedTime(eventConfSourceMetadataDto.getNow());
            source.setFileOrder(Integer.valueOf(eventConfSourceMetadataDto.getFileOrder()));
        }
        source.setName(eventConfSourceMetadataDto.getFilename());
        source.setEventCount(Integer.valueOf(eventConfSourceMetadataDto.getEventCount()));
        source.setEnabled(Boolean.valueOf(true));
        source.setUploadedBy(eventConfSourceMetadataDto.getUsername());
        source.setLastModified(eventConfSourceMetadataDto.getNow());
        source.setVendor(eventConfSourceMetadataDto.getVendor());
        source.setDescription(eventConfSourceMetadataDto.getDescription());
        this.eventConfSourceDao.saveOrUpdate(source);
        return this.eventConfSourceDao.get(source.getId());
    }

    private void saveEvents(EventConfSource source, Events events, String username, Date now) {
        List eventEntities = EventConfServiceHelper.createEventConfEventEntities((EventConfSource)source, (List)events.getEvents(), (String)username, (Date)now);
        this.eventConfEventDao.saveAll((Collection)eventEntities);
    }

    @PreDestroy
    public void shutdown() {
        this.eventConfExecutor.shutdown();
    }

    private void saveEventsToDatabase() {
        Map fileEventsMap = this.eventConfDao.getRootEvents().getLoadedEventFiles();
        int fileOrder = 1;
        for (Map.Entry entry : fileEventsMap.entrySet()) {
            String fileName = (String)entry.getKey();
            if (fileName.startsWith("events/")) {
                String[] parts = fileName.split("/");
                fileName = parts[parts.length - 1];
            }
            Events events = (Events)entry.getValue();
            if (!fileName.startsWith("opennms")) continue;
            String withoutExtension = fileName.endsWith(".xml") ? fileName.substring(0, fileName.lastIndexOf(".xml")) : fileName;
            EventConfSourceMetadataDto metadataDto = new EventConfSourceMetadataDto.Builder().filename(withoutExtension).now(new Date()).vendor(StringUtils.substringBefore((String)fileName, (String)".")).username("system-migration").description("").eventCount(events.getEvents().size()).fileOrder(fileOrder++).build();
            this.persistEventConfFile(events, metadataDto);
        }
    }

    public void reloadEventsIntoMemory() {
        EventConfServiceHelper.reloadEventsFromDBAsync((EventConfEventDao)this.eventConfEventDao, (EventConfDao)this.eventConfDao, (ExecutorService)this.eventConfExecutor);
    }

    public Map<String, Object> filterConfEventsBySourceId(Long sourceId, String eventFilter, String eventSortBy, String eventOrder, Integer totalRecords, Integer offset, Integer limit) {
        return this.eventConfEventDao.findBySourceId(sourceId, eventFilter, eventSortBy, eventOrder, totalRecords, offset, limit);
    }

    public Map<String, Object> filterEventConfSource(String filter, String sortBy, String order, Integer totalRecords, Integer offset, Integer limit) {
        return this.eventConfSourceDao.filterEventConfSource(filter, sortBy, order, totalRecords, offset, limit);
    }

    @Transactional
    public void deleteEventsForSource(Long sourceId, EventConfEventDeletePayload eventConfEventDeletePayload) throws Exception {
        if (eventConfEventDeletePayload.getEventIds() == null || eventConfEventDeletePayload.getEventIds().isEmpty()) {
            throw new IllegalArgumentException("Event IDs to delete must not be empty");
        }
        EventConfSource source = this.eventConfSourceDao.get(sourceId);
        if (source == null) {
            throw new EntityNotFoundException("EventConfSource not found for id: " + sourceId);
        }
        Set databaseEventIds = source.getEvents().stream().map(EventConfEvent::getId).collect(Collectors.toSet());
        List<Long> requestEventIds = eventConfEventDeletePayload.getEventIds();
        List<Long> existingEventIds = requestEventIds.stream().filter(databaseEventIds::contains).toList();
        if (existingEventIds.isEmpty()) {
            throw new EntityNotFoundException("No matching events found in database for deletion. Request IDs: " + String.valueOf(requestEventIds));
        }
        Integer currentCount = source.getEventCount();
        int deleteCount = existingEventIds.size();
        if (deleteCount >= currentCount) {
            LOG.info("Deleting entire sourceId={} as all {} events are removed.", (Object)sourceId, (Object)deleteCount);
            this.eventConfSourceDao.delete(source);
        } else {
            LOG.info("Deleting {} events from sourceId={} (remaining count={})", new Object[]{deleteCount, sourceId, currentCount - deleteCount});
            this.eventConfEventDao.deleteByEventIds(sourceId, existingEventIds);
            source.setEventCount(Integer.valueOf(currentCount - deleteCount));
            this.eventConfSourceDao.saveOrUpdate(source);
        }
    }
}

