/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.net.InetAddress;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.support.CreateIfNecessaryTemplate;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoredServiceList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@Component(value="onmsMonitoredServiceResource")
@Transactional
public class OnmsMonitoredServiceResource
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsMonitoredServiceResource.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_serviceDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsMonitoredServiceList getServices(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
        }
        OnmsIpInterface iface = node.getIpInterfaceByIpAddress(ipAddress);
        if (iface == null) {
            throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "IP Interface {} was not found on node {}.", ipAddress, nodeCriteria);
        }
        return new OnmsMonitoredServiceList((Collection)iface.getMonitoredServices());
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{service}")
    public OnmsMonitoredService getService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String service) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
        }
        OnmsIpInterface iface = node.getIpInterfaceByIpAddress(ipAddress);
        if (iface == null) {
            throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "IP Interface {} was not found on node {}.", ipAddress, nodeCriteria);
        }
        OnmsMonitoredService svc = iface.getMonitoredServiceByServiceType(service);
        if (svc == null) {
            throw OnmsMonitoredServiceResource.getException(Response.Status.NOT_FOUND, "Monitored Service {} was not found on IP Interface {} and node {}.", service, ipAddress, nodeCriteria);
        }
        return svc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response addService(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, final OnmsMonitoredService service) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
            }
            OnmsIpInterface intf = node.getIpInterfaceByIpAddress(ipAddress);
            if (intf == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "IP Interface {} was not found on node {}.", ipAddress, nodeCriteria);
            }
            if (service == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "Service object cannot be null", new String[0]);
            }
            if (service.getServiceName() == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "Service must have a name", new String[0]);
            }
            OnmsServiceType serviceType = (OnmsServiceType)new CreateIfNecessaryTemplate<OnmsServiceType, ServiceTypeDao>(this.m_transactionManager, this.m_serviceTypeDao){

                protected OnmsServiceType query() {
                    return ((ServiceTypeDao)this.m_dao).findByName(service.getServiceName());
                }

                protected OnmsServiceType doInsert() {
                    LOG.info("addService: creating service type {}", (Object)service.getServiceName());
                    OnmsServiceType s = new OnmsServiceType(service.getServiceName());
                    ((ServiceTypeDao)this.m_dao).saveOrUpdate((Object)s);
                    return s;
                }
            }.execute();
            service.setServiceType(serviceType);
            service.setIpInterface(intf);
            LOG.debug("addService: adding service {}", (Object)service);
            this.m_serviceDao.save((Object)service);
            Event e = EventUtils.createNodeGainedServiceEvent((String)"ReST", (int)node.getId(), (InetAddress)intf.getIpAddress(), (String)service.getServiceName(), (String)node.getLabel(), (OnmsNode.NodeLabelSource)node.getLabelSource(), (String)node.getSysName(), (String)node.getSysDescription());
            this.sendEvent(e);
            Response response = Response.created((URI)OnmsMonitoredServiceResource.getRedirectUri(uriInfo, service.getServiceName())).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{service}")
    public Response updateService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String serviceName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Response response;
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
            }
            OnmsIpInterface intf = node.getIpInterfaceByIpAddress(ipAddress);
            if (intf == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "IP Interface {} was not found on node {}.", ipAddress, nodeCriteria);
            }
            OnmsMonitoredService service = intf.getMonitoredServiceByServiceType(serviceName);
            if (service == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "Monitored Service {} was not found on IP Interface {} and node {}.", serviceName, ipAddress, nodeCriteria);
            }
            LOG.debug("updateService: updating service {}", (Object)service);
            boolean modified = false;
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)service);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                if (key.equals("status")) {
                    if ("S".equals(value) || "A".equals(service.getStatus()) && "F".equals(value)) {
                        LOG.debug("updateService: suspending polling for service {} on node with IP {}", (Object)service.getServiceName(), (Object)service.getIpAddress().getHostAddress());
                        value = "F";
                        this.sendEvent("uei.opennms.org/internal/poller/suspendPollingService", service);
                    }
                    if ("R".equals(value) || "F".equals(service.getStatus()) && "A".equals(value)) {
                        LOG.debug("updateService: resuming polling for service {} on node with IP {}", (Object)service.getServiceName(), (Object)service.getIpAddress().getHostAddress());
                        value = "A";
                        this.sendEvent("uei.opennms.org/internal/poller/resumePollingService", service);
                    }
                }
                wrapper.setPropertyValue(key, value);
                modified = true;
            }
            if (modified) {
                LOG.debug("updateSservice: service {} updated", (Object)service);
                this.m_serviceDao.saveOrUpdate((Object)service);
                response = Response.noContent().build();
                return response;
            }
            response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{service}")
    public Response deleteService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String serviceName) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
            }
            OnmsIpInterface intf = node.getIpInterfaceByIpAddress(ipAddress);
            if (intf == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "IP Interface {} was not found on node {}.", ipAddress, nodeCriteria);
            }
            OnmsMonitoredService service = intf.getMonitoredServiceByServiceType(serviceName);
            if (service == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.CONFLICT, "Monitored Service {} was not found on IP Interface {} and node {}.", serviceName, ipAddress, nodeCriteria);
            }
            LOG.debug("deleteService: deleting service {} from node {}", (Object)serviceName, (Object)nodeCriteria);
            Event e = EventUtils.createDeleteServiceEvent((String)"OpenNMS.REST", (long)node.getId().intValue(), (String)ipAddress, (String)serviceName, (long)-1L);
            this.sendEvent(e);
            Response response = Response.accepted().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void sendEvent(String eventUEI, OnmsMonitoredService dbObj) {
        EventBuilder bldr = new EventBuilder(eventUEI, "ReST");
        bldr.setNodeid((long)dbObj.getNodeId().intValue());
        bldr.setInterface(dbObj.getIpAddress());
        bldr.setService(dbObj.getServiceName());
        this.sendEvent(bldr.getEvent());
    }

    private void sendEvent(Event event) {
        try {
            this.m_eventProxy.send(event);
        }
        catch (EventProxyException e) {
            throw OnmsMonitoredServiceResource.getException(Response.Status.INTERNAL_SERVER_ERROR, "Cannot send event {} : {}", event.getUei(), e.getMessage());
        }
    }
}

