/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.criteria.restrictions.SqlRestriction;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.web.api.ISO8601DateEditor;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.CriteriaValueConverters;
import org.opennms.web.rest.support.StringCriteriaBehavior;

public abstract class CriteriaBehaviors {
    public static final Map<String, CriteriaBehavior<?>> ALARM_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> ALARM_LASTEVENT_PARAMETER_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> ASSET_RECORD_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> DIST_POLLER_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> EVENT_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> EVENT_PARAMETER_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> IP_INTERFACE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> MEMO_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> MONITORED_SERVICE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> MONITORING_LOCATION_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> NODE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> NODE_CATEGORY_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> NOTIFICATION_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> OUTAGE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> REDUCTION_KEY_MEMO_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> SERVICE_TYPE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> SNMP_INTERFACE_BEHAVIORS = new HashMap();

    public static Date parseDate(String string) {
        return ISO8601DateEditor.stringToDate((String)string);
    }

    public static final Map<String, CriteriaBehavior<?>> withAliasPrefix(Aliases alias, Map<String, CriteriaBehavior<?>> behaviors) {
        HashMap retval = new HashMap();
        for (Map.Entry<String, CriteriaBehavior<?>> entry : behaviors.entrySet()) {
            retval.put(alias.prop(entry.getKey()), entry.getValue());
        }
        return retval;
    }

    public static final Map<String, CriteriaBehavior<?>> withAliasPrefix(String alias, Map<String, CriteriaBehavior<?>> behaviors) {
        HashMap retval = new HashMap();
        for (Map.Entry<String, CriteriaBehavior<?>> entry : behaviors.entrySet()) {
            retval.put(alias + "." + entry.getKey(), entry.getValue());
        }
        return retval;
    }

    private static String stringForNumericCondition(ConditionType c, String property) {
        String op = "";
        switch (c) {
            case EQUALS: {
                op = " = ";
                break;
            }
            case NOT_EQUALS: {
                op = " != ";
                break;
            }
            case LESS_THAN: {
                op = " < ";
                break;
            }
            case GREATER_THAN: {
                op = " > ";
                break;
            }
            case LESS_OR_EQUALS: {
                op = " <= ";
                break;
            }
            case GREATER_OR_EQUALS: {
                op = " >= ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal condition type when filtering " + property + ": " + c.toString());
            }
        }
        return op;
    }

    static {
        ALARM_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        ALARM_BEHAVIORS.put("alarmAckTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        ALARM_BEHAVIORS.put("alarmType", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        ALARM_BEHAVIORS.put("counter", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        ALARM_BEHAVIORS.put("firstAutomationTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        ALARM_BEHAVIORS.put("firstEventTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        ALARM_BEHAVIORS.put("ifIndex", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        ALARM_BEHAVIORS.put("ipAddr", new CriteriaBehavior<InetAddress>(CriteriaValueConverters.INET_ADDRESS_CONVERTER));
        ALARM_BEHAVIORS.put("lastAutomationTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        ALARM_BEHAVIORS.put("lastEventTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        ALARM_BEHAVIORS.put("severity", new CriteriaBehavior<OnmsSeverity>(OnmsSeverity::get));
        ALARM_BEHAVIORS.put("suppressedTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        ALARM_BEHAVIORS.put("suppressedUntil", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        ALARM_BEHAVIORS.put("troubleTicketState", new CriteriaBehavior<TroubleTicketState>(TroubleTicketState::valueOf));
        ALARM_BEHAVIORS.put("TTicketId", new CriteriaBehavior<String>(CriteriaValueConverters.STRING_CONVERTER));
        ALARM_BEHAVIORS.put("x733ProbableCause", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        StringCriteriaBehavior affectedNodeCount = new StringCriteriaBehavior(Aliases.alarm.prop("affectedNodeCount"), (b, v, c, w) -> {
            String op = CriteriaBehaviors.stringForNumericCondition(c, "alarm.affectedNodeCount");
            b.sql("((SELECT COUNT (DISTINCT NODEID) from (SELECT NODEID FROM alarms where alarmid in (SELECT related_alarm_id from alarm_situations where situation_id = {alias}.alarmid) or alarmid = {alias}.alarmid) as from_nodes) " + op + " " + String.valueOf(v) + " ) ");
        });
        affectedNodeCount.setSkipPropertyByDefault(true);
        ALARM_BEHAVIORS.put("affectedNodeCount", affectedNodeCount);
        StringCriteriaBehavior isAcknowledged = new StringCriteriaBehavior(Aliases.alarm.prop("isAcknowledged"), (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    if (Boolean.valueOf((String)v).booleanValue()) {
                        b.isNotNull("alarm.alarmAckTime");
                        break;
                    }
                    b.isNull("alarm.alarmAckTime");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering alarm.isAcknowledged: " + c.toString());
                }
            }
        });
        isAcknowledged.setSkipPropertyByDefault(true);
        ALARM_BEHAVIORS.put("isAcknowledged", isAcknowledged);
        StringCriteriaBehavior isSituation = new StringCriteriaBehavior(Aliases.alarm.prop("isSituation"), (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    if (Boolean.valueOf((String)v).booleanValue()) {
                        b.sql("exists (select related_alarm_id from alarm_situations where situation_id = {alias}.alarmid)");
                        break;
                    }
                    b.sql("not exists (select related_alarm_id from alarm_situations where situation_id = {alias}.alarmid)");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering alarm.isSituation: " + c.toString());
                }
            }
        });
        isSituation.setSkipPropertyByDefault(true);
        ALARM_BEHAVIORS.put("isSituation", isSituation);
        StringCriteriaBehavior isInSituation = new StringCriteriaBehavior(Aliases.alarm.prop("isInSituation"), (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    if (Boolean.valueOf((String)v).booleanValue()) {
                        b.sql("exists (select related_alarm_id from alarm_situations where related_alarm_id = {alias}.alarmid)");
                        break;
                    }
                    b.sql("not exists (select related_alarm_id from alarm_situations where related_alarm_id = {alias}.alarmid)");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering alarm.isInSituation: " + c.toString());
                }
            }
        });
        isInSituation.setSkipPropertyByDefault(true);
        ALARM_BEHAVIORS.put("isInSituation", isInSituation);
        StringCriteriaBehavior situationAlarmCount = new StringCriteriaBehavior(Aliases.alarm.prop("situationAlarmCount"), (b, v, c, w) -> {
            String op = CriteriaBehaviors.stringForNumericCondition(c, "alarm.situationAlarmCount");
            b.sql("((SELECT COUNT (DISTINCT related_alarm_id) from alarm_situations where situation_id = {alias}.alarmid ) " + op + " " + String.valueOf(v) + " )");
        });
        situationAlarmCount.setSkipPropertyByDefault(true);
        ALARM_BEHAVIORS.put("situationAlarmCount", situationAlarmCount);
        ALARM_LASTEVENT_PARAMETER_BEHAVIORS.put("name", new EventParameterBehavior("lastEvent.eventParameters", "lasteventid", "name"));
        ALARM_LASTEVENT_PARAMETER_BEHAVIORS.put("value", new EventParameterBehavior("lastEvent.eventParameters", "lasteventid", "value"));
        ALARM_LASTEVENT_PARAMETER_BEHAVIORS.put("type", new EventParameterBehavior("lastEvent.eventParameters", "lasteventid", "type"));
        ASSET_RECORD_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        ASSET_RECORD_BEHAVIORS.put("lastModifiedDate", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        DIST_POLLER_BEHAVIORS.put("lastUpdated", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        EVENT_BEHAVIORS.put("eventAckTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        EVENT_BEHAVIORS.put("eventCreateTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        EVENT_BEHAVIORS.put("eventSeverity", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        EVENT_BEHAVIORS.put("eventSuppressedCount", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        EVENT_BEHAVIORS.put("eventTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        EVENT_BEHAVIORS.put("eventTTicketState", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        EVENT_BEHAVIORS.put("id", new CriteriaBehavior<Long>(CriteriaValueConverters.LONG_CONVERTER));
        EVENT_BEHAVIORS.put("ifIndex", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        EVENT_BEHAVIORS.put("ipAddr", new CriteriaBehavior<InetAddress>(CriteriaValueConverters.INET_ADDRESS_CONVERTER));
        EVENT_PARAMETER_BEHAVIORS.put("name", new EventParameterBehavior(Aliases.event.prop("eventParameters"), "eventid", "name"));
        EVENT_PARAMETER_BEHAVIORS.put("value", new EventParameterBehavior(Aliases.event.prop("eventParameters"), "eventid", "value"));
        EVENT_PARAMETER_BEHAVIORS.put("type", new EventParameterBehavior(Aliases.event.prop("eventParameters"), "eventid", "type"));
        IP_INTERFACE_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        IP_INTERFACE_BEHAVIORS.put("ipLastCapsdPoll", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        IP_INTERFACE_BEHAVIORS.put("ipAddress", new CriteriaBehavior<InetAddress>(CriteriaValueConverters.INET_ADDRESS_CONVERTER));
        IP_INTERFACE_BEHAVIORS.put("netMask", new CriteriaBehavior<InetAddress>(CriteriaValueConverters.INET_ADDRESS_CONVERTER));
        IP_INTERFACE_BEHAVIORS.put("snmpPrimary", new CriteriaBehavior<Character>(CriteriaValueConverters.CHARACTER_CONVERTER));
        MONITORED_SERVICE_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        MONITORED_SERVICE_BEHAVIORS.put("lastFail", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        MONITORED_SERVICE_BEHAVIORS.put("lastGood", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        MONITORING_LOCATION_BEHAVIORS.put("latitude", new CriteriaBehavior<Float>(CriteriaValueConverters.FLOAT_CONVERTER));
        MONITORING_LOCATION_BEHAVIORS.put("longitude", new CriteriaBehavior<Float>(CriteriaValueConverters.FLOAT_CONVERTER));
        MONITORING_LOCATION_BEHAVIORS.put("priority", new CriteriaBehavior<Long>(CriteriaValueConverters.LONG_CONVERTER));
        NODE_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        NODE_BEHAVIORS.put("createTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        NODE_BEHAVIORS.put("lastCapsdPoll", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        NODE_BEHAVIORS.put("lastEgressFlow", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        NODE_BEHAVIORS.put("lastIngressFlow", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        CriteriaBehavior<Integer> categoryId = new CriteriaBehavior<Integer>(Aliases.category.prop("id"), CriteriaValueConverters.INT_CONVERTER, (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    b.sql("{alias}.nodeid in (select category_node.nodeid from category_node where category_node.categoryid = ?)", v, SqlRestriction.Type.INTEGER);
                    break;
                }
                case NOT_EQUALS: {
                    b.sql("{alias}.nodeid not in (select category_node.nodeid from category_node where category_node.categoryid = ?)", v, SqlRestriction.Type.INTEGER);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering category.id: " + c.toString());
                }
            }
        });
        categoryId.setSkipPropertyByDefault(true);
        NODE_CATEGORY_BEHAVIORS.put("id", categoryId);
        StringCriteriaBehavior categoryName = new StringCriteriaBehavior(Aliases.category.prop("name"), (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    b.sql(String.format("{alias}.nodeid in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categoryname %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                case NOT_EQUALS: {
                    b.sql(String.format("{alias}.nodeid not in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categoryname %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering category.name: " + c.toString());
                }
            }
        });
        categoryName.setSkipPropertyByDefault(true);
        NODE_CATEGORY_BEHAVIORS.put("name", categoryName);
        StringCriteriaBehavior categoryDescription = new StringCriteriaBehavior(Aliases.category.prop("description"), (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    b.sql(String.format("{alias}.nodeid in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categorydescription %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                case NOT_EQUALS: {
                    b.sql(String.format("{alias}.nodeid not in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categorydescription %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering category.description: " + c.toString());
                }
            }
        });
        categoryDescription.setSkipPropertyByDefault(true);
        NODE_CATEGORY_BEHAVIORS.put("description", categoryDescription);
        NOTIFICATION_BEHAVIORS.put("notifyId", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        NOTIFICATION_BEHAVIORS.put("pageTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        NOTIFICATION_BEHAVIORS.put("respondTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        OUTAGE_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        OUTAGE_BEHAVIORS.put("ifLostService", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        OUTAGE_BEHAVIORS.put("ifRegainedService", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        OUTAGE_BEHAVIORS.put("suppressTime", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        SERVICE_TYPE_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("ifAdminStatus", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("ifAlias", new CriteriaBehavior<String>(CriteriaValueConverters.STRING_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("ifDescr", new CriteriaBehavior<String>(CriteriaValueConverters.STRING_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("ifIndex", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("ifName", new CriteriaBehavior<String>(CriteriaValueConverters.STRING_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("ifOperStatus", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("ifSpeed", new CriteriaBehavior<Long>(CriteriaValueConverters.LONG_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("ifType", new CriteriaBehavior<Integer>(CriteriaValueConverters.INT_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("lastCapsdPoll", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("lastEgressFlow", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("lastIngressFlow", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
        SNMP_INTERFACE_BEHAVIORS.put("lastSnmpPoll", new CriteriaBehavior<Date>(CriteriaValueConverters.DATE_CONVERTER));
    }

    private static final class EventParameterBehavior
    extends StringCriteriaBehavior {
        public EventParameterBehavior(String eventParameterPath, String eventIdColumn, String eventParameterProperty) {
            super(Aliases.eventParameter.prop(eventParameterProperty), (CriteriaBuilder b, Object v, ConditionType c, boolean w) -> {
                switch (c) {
                    case EQUALS: {
                        if (w) {
                            b.sql(String.format("{alias}.%s in (select event_parameters.eventid from event_parameters where event_parameters.%s %s ?)", eventIdColumn, eventParameterProperty, w ? "like" : "="), v, SqlRestriction.Type.STRING);
                            break;
                        }
                        b.alias(eventParameterPath, Aliases.eventParameter.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eq((String)Aliases.eventParameter.prop(eventParameterProperty), (Object)v), Restrictions.isNull((String)Aliases.eventParameter.prop(eventParameterProperty))}));
                        break;
                    }
                    case NOT_EQUALS: {
                        b.sql(String.format("{alias}.%s not in (select event_parameters.eventid from event_parameters where event_parameters.%s %s ?)", eventIdColumn, eventParameterProperty, w ? "like" : "="), v, SqlRestriction.Type.STRING);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal condition type when filtering event_parameters." + eventParameterProperty + ": " + c.toString());
                    }
                }
            });
        }

        @Override
        public boolean shouldSkipProperty(ConditionType condition, boolean wildcard) {
            switch (condition) {
                case EQUALS: {
                    return wildcard;
                }
                case NOT_EQUALS: {
                    return true;
                }
            }
            return super.shouldSkipProperty(condition, wildcard);
        }
    }
}

