/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd.shell;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.threshd.shell.AbstractThresholdStateCommand;

@Command(scope="opennms", name="threshold-enumerate", description="Enumerates threshold states")
@Service
public class Enumerate
extends AbstractThresholdStateCommand {
    @Reference
    private NodeDao nodeDao;
    @Option(name="-n", aliases={"--node"}, description="A node to filter by in the form of either the node's ID or foreign_source:foreign_id")
    private String node;

    public Object execute() {
        AtomicInteger index = new AtomicInteger(1);
        Map<Integer, String> stateKeyIndexes = this.blobStore.enumerateContext("thresholding").entrySet().stream().filter(this.getFilter()).collect(Collectors.toMap(e -> index.getAndIncrement(), Map.Entry::getKey));
        if (stateKeyIndexes.isEmpty()) {
            System.out.println("No threshold states found");
        } else {
            System.out.println("Index\tState Key");
            stateKeyIndexes.forEach((k, v) -> System.out.println(k + "\t" + v));
            this.session.put("opennms_threhsold_states_stateKeyIndexes", stateKeyIndexes);
        }
        return null;
    }

    private Predicate<Map.Entry<String, byte[]>> getFilter() {
        AtomicInteger nodeIdToFilter = new AtomicInteger(-1);
        if (this.node != null) {
            try {
                nodeIdToFilter.set(Integer.parseInt(this.node));
                if (nodeIdToFilter.get() < 0) {
                    throw new IllegalStateException("Node ID must be positive");
                }
                OnmsNode nodeFound = this.nodeDao.get(this.node);
                if (nodeFound == null) {
                    throw new IllegalArgumentException(String.format("No node with ID '%s' could be found", this.node));
                }
            }
            catch (NumberFormatException ignore) {
                OnmsNode nodeFound = this.nodeDao.get(this.node);
                if (nodeFound == null) {
                    throw new IllegalArgumentException(String.format("No node with foreign_source:foreign_id '%s' could be found", this.node));
                }
                nodeIdToFilter.set(nodeFound.getId());
            }
        }
        return entry -> {
            int nodeId = nodeIdToFilter.get();
            if (nodeId >= 0) {
                return ((String)entry.getKey()).startsWith(nodeId + "-");
            }
            return true;
        };
    }
}

