/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd.shell;

import java.util.concurrent.CompletableFuture;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.threshd.api.ThresholdStateMonitor;
import org.opennms.netmgt.threshd.shell.AbstractThresholdStateCommand;

@Command(scope="opennms", name="threshold-clear-all", description="Clears all threshold states")
@Service
public class ClearAll
extends AbstractThresholdStateCommand {
    @Reference
    ThresholdStateMonitor thresholdStateMonitor;
    @Option(name="-p", aliases={"--persisted-only"}, description="When set, clears only the persisted state")
    private boolean clearPersistedOnly;

    public Object execute() throws InterruptedException {
        System.out.print("Clearing all thresholding states...");
        CompletableFuture clearFuture = this.clearPersistedOnly ? this.blobStore.truncateContextAsync("thresholding") : CompletableFuture.supplyAsync(() -> {
            this.thresholdStateMonitor.reinitializeStates();
            return null;
        });
        while (!clearFuture.isDone()) {
            Thread.sleep(1000L);
            System.out.print('.');
        }
        try {
            clearFuture.get();
            System.out.println("done");
        }
        catch (Exception e) {
            System.out.println("Failed to clear all states" + String.valueOf(e));
        }
        return null;
    }
}

