/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.spring.web;

import javax.servlet.ServletContext;
import org.opennms.core.spring.BeanFactoryReference;
import org.opennms.core.spring.ContextRegistry;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class ContextLoaderListener
extends org.springframework.web.context.ContextLoaderListener {
    protected WebApplicationContext createWebApplicationContext(ServletContext sc) {
        String parentContextKey = sc.getInitParameter("parentContextKey");
        ConfigurableWebApplicationContext context = (ConfigurableWebApplicationContext)super.createWebApplicationContext(sc);
        if (parentContextKey != null) {
            try {
                BeanFactoryReference parentRef = ContextRegistry.getInstance().getBeanFactory(parentContextKey);
                BeanFactory parentFactory = parentRef.getFactory();
                if (parentFactory instanceof ConfigurableApplicationContext) {
                    context.setParent((ApplicationContext)((ConfigurableApplicationContext)parentFactory));
                }
            }
            catch (Exception e) {
                sc.log("Failed to load parent context '" + parentContextKey + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return context;
    }
}

