/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.openconfig.adapter;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.opennms.features.openconfig.proto.gnmi.Gnmi;
import org.opennms.features.openconfig.proto.jti.Telemetry;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractScriptedCollectionAdapter;
import org.opennms.netmgt.telemetry.protocols.collection.CollectionSetWithAgent;
import org.opennms.netmgt.telemetry.protocols.collection.ScriptedCollectionSetBuilder;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class OpenConfigAdapter
extends AbstractScriptedCollectionAdapter {
    private final String DEFAULT_MODE = "gnmi";
    private final String JTI_MODE = "jti";
    private CollectionAgentFactory collectionAgentFactory;
    private InterfaceToNodeCache interfaceToNodeCache;
    private NodeDao nodeDao;
    private TransactionOperations transactionTemplate;
    private String mode;

    public OpenConfigAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry) {
        super(adapterConfig, metricRegistry);
    }

    public Stream<CollectionSetWithAgent> handleCollectionMessage(TelemetryMessageLogEntry message, TelemetryMessageLog messageLog) {
        try {
            if ("jti".equalsIgnoreCase(this.mode)) {
                Telemetry.OpenConfigData openConfigData = Telemetry.OpenConfigData.parseFrom((byte[])message.getByteArray());
                String systemId = openConfigData.getSystemId();
                CollectionAgent agent = this.getCollectionAgent(messageLog, systemId);
                return this.buildCollectionSet(agent, openConfigData, openConfigData.getTimestamp());
            }
            Gnmi.SubscribeResponse subscribeResponse = Gnmi.SubscribeResponse.parseFrom((byte[])message.getByteArray());
            Gnmi.Notification notification = subscribeResponse.getUpdate();
            long timeStamp = notification.getTimestamp();
            CollectionAgent agent = this.getCollectionAgent(messageLog, null);
            return this.buildCollectionSet(agent, subscribeResponse, timeStamp);
        }
        catch (InvalidProtocolBufferException e) {
            this.LOG.warn("Invalid packet: ", (Throwable)e);
            return Stream.empty();
        }
    }

    public void setCollectionAgentFactory(CollectionAgentFactory collectionAgentFactory) {
        this.collectionAgentFactory = collectionAgentFactory;
    }

    public void setInterfaceToNodeCache(InterfaceToNodeCache interfaceToNodeCache) {
        this.interfaceToNodeCache = interfaceToNodeCache;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public void setTransactionTemplate(TransactionOperations transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    private CollectionAgent getCollectionAgent(TelemetryMessageLog messageLog, final String systemId) {
        CollectionAgent agent = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(messageLog.getSourceAddress());
            Optional nodeId = this.interfaceToNodeCache.getFirstNodeId(messageLog.getLocation(), inetAddress);
            if (nodeId.isPresent()) {
                agent = this.collectionAgentFactory.createCollectionAgent(Integer.toString((Integer)nodeId.get()), inetAddress);
            }
        }
        catch (UnknownHostException e) {
            this.LOG.debug("Could not convert resolve from source address: {}", (Object)messageLog.getSourceAddress());
        }
        if (agent == null && !Strings.isNullOrEmpty((String)systemId)) {
            agent = (CollectionAgent)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<CollectionAgent>(){

                public CollectionAgent doInTransaction(TransactionStatus status) {
                    OnmsNode node = (OnmsNode)Iterables.getFirst((Iterable)OpenConfigAdapter.this.nodeDao.findByLabel(systemId), null);
                    if (node != null) {
                        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
                        return OpenConfigAdapter.this.collectionAgentFactory.createCollectionAgent(primaryInterface);
                    }
                    return null;
                }
            });
        }
        return agent;
    }

    private Stream<CollectionSetWithAgent> buildCollectionSet(CollectionAgent collectionAgent, Object response, long timeStamp) {
        ScriptedCollectionSetBuilder builder = this.getCollectionBuilder();
        if (builder == null) {
            this.LOG.error("Error compiling script '{}'. See logs for details.", (Object)this.getScript());
            return Stream.empty();
        }
        try {
            CollectionSet collectionSet = builder.build(collectionAgent, response, Long.valueOf(timeStamp));
            return Stream.of(new CollectionSetWithAgent(collectionAgent, collectionSet));
        }
        catch (ScriptException e) {
            this.LOG.warn("Error while running script: {}: {}", (Object)this.getScript(), (Object)e);
            return Stream.empty();
        }
    }
}

