/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.grpc.common;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.opennms.core.grpc.common.GrpcIpcServer;
import org.opennms.core.grpc.common.GrpcIpcUtils;
import org.opennms.core.utils.PropertiesUtils;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcIpcServerBuilder
implements GrpcIpcServer {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcIpcServerBuilder.class);
    private final ConfigurationAdmin configAdmin;
    private Properties properties;
    private NettyServerBuilder serverBuilder;
    private Server server;
    private final int port;
    private final Duration delay;
    private boolean serverStartScheduled = false;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private Set<BindableService> services = new HashSet<BindableService>();

    public GrpcIpcServerBuilder(ConfigurationAdmin configAdmin, int port, String delay) {
        this.configAdmin = configAdmin;
        this.port = port;
        this.delay = Duration.parse(delay);
        this.properties = GrpcIpcUtils.getPropertiesFromConfig(configAdmin, "org.opennms.core.ipc.grpc.server");
    }

    @Override
    public synchronized void startServer(BindableService bindableService) throws IOException {
        this.initializeServerFromConfig();
        if (!this.services.contains(bindableService)) {
            this.serverBuilder.addService(bindableService);
            this.services.add(bindableService);
        }
        if (!this.serverStartScheduled) {
            this.startServerWithDelay(this.delay.toMillis());
            this.serverStartScheduled = true;
        }
    }

    @Override
    public synchronized void stopServer() {
        if (this.server != null && !this.server.isShutdown()) {
            this.server.shutdownNow();
        }
        this.services.clear();
        this.serverStartScheduled = false;
    }

    private void initializeServerFromConfig() {
        if (this.serverBuilder == null) {
            SslContextBuilder sslContextBuilder;
            int maxInboundMessageSize = PropertiesUtils.getProperty((Properties)this.properties, (String)"max.message.size", (int)0xA00000);
            boolean tlsEnabled = PropertiesUtils.getProperty((Properties)this.properties, (String)"tls.enabled", (boolean)false);
            this.serverBuilder = NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(this.port)).maxInboundMessageSize(maxInboundMessageSize);
            if (tlsEnabled && (sslContextBuilder = GrpcIpcUtils.getSslContextBuilder(this.properties)) != null) {
                try {
                    this.serverBuilder.sslContext(sslContextBuilder.build());
                    LOG.info("TLS enabled for Grpc IPC Server");
                }
                catch (SSLException e) {
                    LOG.error("Couldn't initialize ssl context from {}", (Object)this.properties, (Object)e);
                }
            }
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    private void startServerWithDelay(long delay) {
        this.executor.schedule(this::startServerNow, delay, TimeUnit.MILLISECONDS);
    }

    private void startServerNow() {
        this.server = this.serverBuilder.build();
        try {
            this.server.start();
            LOG.info("OpenNMS IPC gRPC server started with {} services", (Object)this.services.size());
        }
        catch (IOException e) {
            LOG.error("Exception while starting IPC Grpc Server", (Throwable)e);
        }
    }
}

