/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.jfree.chart.axis;

import java.io.Serializable;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;
import org.opennms.shaded.jasper.org.jfree.chart.util.ParamChecks;

public abstract class Tick
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6668230383875149773L;
    private String text;
    private TextAnchor textAnchor;
    private TextAnchor rotationAnchor;
    private double angle;

    public Tick(String text, TextAnchor textAnchor, TextAnchor rotationAnchor, double angle) {
        ParamChecks.nullNotPermitted(textAnchor, "textAnchor");
        ParamChecks.nullNotPermitted(rotationAnchor, "rotationAnchor");
        this.text = text;
        this.textAnchor = textAnchor;
        this.rotationAnchor = rotationAnchor;
        this.angle = angle;
    }

    public String getText() {
        return this.text;
    }

    public TextAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public TextAnchor getRotationAnchor() {
        return this.rotationAnchor;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tick) {
            Tick t = (Tick)obj;
            if (!ObjectUtilities.equal((Object)this.text, (Object)t.text)) {
                return false;
            }
            if (!ObjectUtilities.equal((Object)this.textAnchor, (Object)t.textAnchor)) {
                return false;
            }
            if (!ObjectUtilities.equal((Object)this.rotationAnchor, (Object)t.rotationAnchor)) {
                return false;
            }
            return this.angle == t.angle;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Tick clone = (Tick)super.clone();
        return clone;
    }

    public String toString() {
        return this.text;
    }
}

