/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.xml.validators;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.opennms.shaded.jasper.org.exolab.castor.util.RegExpEvaluator;
import org.opennms.shaded.jasper.org.exolab.castor.xml.ValidationContext;
import org.opennms.shaded.jasper.org.exolab.castor.xml.ValidationException;

public abstract class PatternValidator {
    protected static ResourceBundle resourceBundle = ResourceBundle.getBundle("ValidationMessages", Locale.getDefault());
    private LinkedList<String> _patterns = new LinkedList();
    private boolean _nillable = false;
    private RegExpEvaluator _regex = null;

    public PatternValidator() {
    }

    public PatternValidator(String pattern) {
        this._patterns.add(pattern);
    }

    public List<String> getPatterns() {
        return Collections.unmodifiableList(this._patterns);
    }

    public boolean isNillable() {
        return this._nillable;
    }

    public boolean hasPattern() {
        return !this._patterns.isEmpty();
    }

    public void setNillable(boolean nillable) {
        this._nillable = nillable;
    }

    public void addPattern(String pattern) {
        this._patterns.add(pattern);
    }

    public void clearPatterns() {
        this._patterns.clear();
    }

    public void validate(String str, ValidationContext context) throws ValidationException {
        if (this._patterns.isEmpty()) {
            return;
        }
        if (context == null) {
            throw new IllegalArgumentException(resourceBundle.getString("patternValidator.error.exception"));
        }
        if (this._regex == null) {
            this.initEvaluator(context);
        }
        for (String pattern : this._patterns) {
            this._regex.setExpression(pattern);
            if (!this._regex.matches(str)) continue;
            return;
        }
        StringBuilder buff = new StringBuilder("'" + str + "'");
        if (this._patterns.size() == 1) {
            buff.append(MessageFormat.format(resourceBundle.getString("patternValidator.error.pattern.not.match"), this._patterns.getFirst()));
        } else {
            StringBuilder patterns = new StringBuilder();
            for (String pattern : this._patterns) {
                patterns.append('\"');
                patterns.append(pattern);
                patterns.append('\"');
            }
            buff.append(MessageFormat.format(resourceBundle.getString("patternValidator.error.pattern.not.match.any"), patterns.toString()));
        }
        throw new ValidationException(buff.toString());
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            if (!this._nillable) {
                String err = resourceBundle.getString("patternValidator.error.cannot.validate.null.object");
                throw new ValidationException(err);
            }
            return;
        }
        this.validate(object.toString(), context);
    }

    private void initEvaluator(ValidationContext context) {
        this._regex = context.getInternalContext().getRegExpEvaluator();
        if (this._regex == null && this.hasPattern()) {
            throw new IllegalStateException(resourceBundle.getString("patternValidator.error.exception.noPatterns"));
        }
    }
}

