/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.xml.util.resolvers;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opennms.shaded.jasper.org.exolab.castor.xml.ResolverException;
import org.opennms.shaded.jasper.org.exolab.castor.xml.util.resolvers.AbstractResolverClassCommand;
import org.opennms.shaded.jasper.org.exolab.castor.xml.util.resolvers.ResolveHelpers;

public class ByDescriptorClass
extends AbstractResolverClassCommand {
    private static final Log LOG = LogFactory.getLog(ByDescriptorClass.class);

    @Override
    protected Map internalResolve(String className, ClassLoader classLoader, Map properties) throws ResolverException {
        int offset;
        HashMap results = new HashMap();
        if (classLoader == null) {
            LOG.debug((Object)"No class loader available.");
            return results;
        }
        StringBuilder descriptorClassName = new StringBuilder(className);
        descriptorClassName.append("Descriptor");
        Class descriptorClass = ResolveHelpers.loadClass(classLoader, descriptorClassName.toString());
        if (descriptorClass == null && (offset = descriptorClassName.lastIndexOf(".")) != -1) {
            descriptorClassName.insert(offset, ".");
            descriptorClassName.insert(offset + 1, "descriptors");
            descriptorClass = ResolveHelpers.loadClass(classLoader, descriptorClassName.toString());
        }
        if (descriptorClass != null) {
            try {
                LOG.debug((Object)("Found descriptor: " + descriptorClass));
                results.put(className, descriptorClass.newInstance());
            }
            catch (InstantiationException e) {
                LOG.debug((Object)("Ignored exception: " + e + "at loading descriptor class for: " + className));
            }
            catch (IllegalAccessException e) {
                LOG.debug((Object)("Ignored exception: " + e + "at loading descriptor class for: " + className));
            }
        }
        return results;
    }
}

