/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.xml.util;

import org.opennms.shaded.jasper.org.exolab.castor.xml.NamespacesStack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class DocumentHandlerAdapter
implements ContentHandler {
    private static final String CDATA = "CDATA";
    private DocumentHandler _handler = null;
    private NamespacesStack namespacesStack = null;
    private boolean _createNamespaceScope = true;

    public DocumentHandlerAdapter(DocumentHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("The argument 'handler' must not be null.");
        }
        this._handler = handler;
        this.namespacesStack = new NamespacesStack();
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this._handler.characters(chars, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this._handler.endDocument();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this._handler.endElement(qName);
        this.namespacesStack.removeNamespaceScope();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
        this._handler.ignorableWhitespace(chars, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this._handler.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._handler.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this._handler.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        AttributeListImpl attList = new AttributeListImpl();
        if (this._createNamespaceScope) {
            this.namespacesStack.addNewNamespaceScope();
        } else {
            this._createNamespaceScope = true;
            this.namespacesStack.declareAsAttributes(attList, true);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            attList.addAttribute(atts.getQName(i), CDATA, atts.getValue(i));
        }
        this._handler.startElement(qName, attList);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this._createNamespaceScope) {
            this.namespacesStack.addNewNamespaceScope();
            this._createNamespaceScope = false;
        }
        this.namespacesStack.addNamespace(prefix, uri);
    }
}

