/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.opennms.shaded.jasper.org.exolab.castor.types.DateTimeBase;

public class GDay
extends DateTimeBase {
    private static final long serialVersionUID = 8571596440117087631L;
    private static final String DAY_FORMAT = "---dd";
    private static final String BAD_GDAY = "Bad gDay format: ";

    public GDay() {
    }

    public GDay(short day) {
        this.setDay(day);
    }

    public GDay(int day) {
        this.setDay((short)day);
    }

    public GDay(String gday) throws ParseException {
        GDay.parseGDayInternal(gday, this);
    }

    @Override
    public void setValues(short[] values) {
        if (values.length != 1) {
            throw new IllegalArgumentException("GDay#setValues: not the right number of values");
        }
        this.setDay(values[0]);
    }

    @Override
    public short[] getValues() {
        short[] result = new short[]{this.getDay()};
        return result;
    }

    @Override
    public Date toDate() {
        SimpleDateFormat df = new SimpleDateFormat(DAY_FORMAT);
        this.setDateFormatTimeZone(df);
        Date date = null;
        try {
            date = df.parse(this.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("---");
        if (this.getDay() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getDay());
        this.appendTimeZoneString(result);
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return GDay.parseGDay(str);
    }

    public static GDay parseGDay(String str) throws ParseException {
        GDay result = new GDay();
        return GDay.parseGDayInternal(str, result);
    }

    private static GDay parseGDayInternal(String str, GDay result) throws ParseException {
        char[] chars;
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new GDay();
        }
        if ((chars = str.toCharArray())[0] != '-' || chars[1] != '-' || chars[2] != '-') {
            throw new ParseException(BAD_GDAY + str + "\nA gDay must follow the pattern ---DD(Z|((+|-)hh:mm)).", 0);
        }
        int idx = 2;
        idx = GDay.parseDay(str, result, chars, idx, BAD_GDAY);
        GDay.parseTimeZone(str, result, chars, idx, BAD_GDAY);
        return result;
    }

    @Override
    public boolean hasIsNegative() {
        return false;
    }

    @Override
    public boolean isNegative() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a 'negative' field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setNegative() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay cannot be negative.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasCentury() {
        return false;
    }

    @Override
    public short getCentury() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Century field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setCentury(short century) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Century field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasYear() {
        return false;
    }

    @Override
    public short getYear() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Year field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setYear(short year) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Year field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasMonth() {
        return false;
    }

    @Override
    public short getMonth() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Month field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setMonth(short month) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Month field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasHour() {
        return false;
    }

    @Override
    public short getHour() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have an Hour field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setHour(short hour) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have an Hour field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasMinute() {
        return false;
    }

    @Override
    public short getMinute() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Minute field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setMinute(short minute) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Minute field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasSeconds() {
        return false;
    }

    @Override
    public short getSeconds() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Seconds field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setSecond(short second) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Seconds field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasMilli() {
        return false;
    }

    @Override
    public short getMilli() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Milliseconds field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setMilliSecond(short millisecond) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GDay does not have a Milliseconds field.";
        throw new UnsupportedOperationException(err);
    }
}

