/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.com.lowagie.text.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.opennms.shaded.jasper.com.lowagie.text.Document;
import org.opennms.shaded.jasper.com.lowagie.text.DocumentException;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.BaseFont;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.GlyphList;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfArray;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfDictionary;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfEncodings;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfIndirectObject;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfIndirectReference;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfName;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfNumber;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfObject;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfRectangle;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfStream;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfWriter;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.Pfm2afm;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.RandomAccessFileOrArray;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.fonts.FontsResourceAnchor;

class Type1Font
extends BaseFont {
    private static FontsResourceAnchor resourceAnchor;
    protected byte[] pfb;
    private String FontName;
    private String FullName;
    private String FamilyName;
    private String Weight = "";
    private float ItalicAngle = 0.0f;
    private boolean IsFixedPitch = false;
    private String CharacterSet;
    private int llx = -50;
    private int lly = -200;
    private int urx = 1000;
    private int ury = 900;
    private int UnderlinePosition = -100;
    private int UnderlineThickness = 50;
    private String EncodingScheme = "FontSpecific";
    private int CapHeight = 700;
    private int XHeight = 480;
    private int Ascender = 800;
    private int Descender = -200;
    private int StdHW;
    private int StdVW = 80;
    private HashMap CharMetrics = new HashMap();
    private HashMap KernPairs = new HashMap();
    private String fileName;
    private boolean builtinFont = false;
    private static final int[] PFB_TYPES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type1Font(String string, String string2, boolean bl, byte[] byArray, byte[] byArray2, boolean bl2) throws DocumentException, IOException {
        if (bl && byArray != null && byArray2 == null) {
            throw new DocumentException("Two byte arrays are needed if the Type1 font is embedded.");
        }
        if (bl && byArray != null) {
            this.pfb = byArray2;
        }
        this.encoding = string2;
        this.embedded = bl;
        this.fileName = string;
        this.fontType = 0;
        RandomAccessFileOrArray randomAccessFileOrArray = null;
        InputStream inputStream = null;
        if (BuiltinFonts14.containsKey(string)) {
            this.embedded = false;
            this.builtinFont = true;
            byte[] byArray3 = new byte[1024];
            try {
                int n;
                if (resourceAnchor == null) {
                    resourceAnchor = new FontsResourceAnchor();
                }
                if ((inputStream = Type1Font.getResourceStream("org/opennms/shaded/jasper/com/lowagie/text/pdf/fonts/" + string + ".afm", resourceAnchor.getClass().getClassLoader())) == null) {
                    String string3 = string + " not found as resource. (The *.afm files must exist as resources in the package com.lowagie.text.pdf.fonts)";
                    System.err.println(string3);
                    throw new DocumentException(string3);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = inputStream.read(byArray3)) >= 0) {
                    byteArrayOutputStream.write(byArray3, 0, n);
                }
                byArray3 = byteArrayOutputStream.toByteArray();
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                randomAccessFileOrArray = new RandomAccessFileOrArray(byArray3);
                this.process(randomAccessFileOrArray);
            }
            finally {
                if (randomAccessFileOrArray != null) {
                    try {
                        randomAccessFileOrArray.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (string.toLowerCase().endsWith(".afm")) {
            try {
                randomAccessFileOrArray = byArray == null ? new RandomAccessFileOrArray(string, bl2, Document.plainRandomAccess) : new RandomAccessFileOrArray(byArray);
                this.process(randomAccessFileOrArray);
            }
            finally {
                if (randomAccessFileOrArray != null) {
                    try {
                        randomAccessFileOrArray.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (string.toLowerCase().endsWith(".pfm")) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                randomAccessFileOrArray = byArray == null ? new RandomAccessFileOrArray(string, bl2, Document.plainRandomAccess) : new RandomAccessFileOrArray(byArray);
                Pfm2afm.convert(randomAccessFileOrArray, byteArrayOutputStream);
                randomAccessFileOrArray.close();
                randomAccessFileOrArray = new RandomAccessFileOrArray(byteArrayOutputStream.toByteArray());
                this.process(randomAccessFileOrArray);
            }
            finally {
                if (randomAccessFileOrArray != null) {
                    try {
                        randomAccessFileOrArray.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        throw new DocumentException(string + " is not an AFM or PFM font file.");
        this.EncodingScheme = this.EncodingScheme.trim();
        if (this.EncodingScheme.equals("AdobeStandardEncoding") || this.EncodingScheme.equals("StandardEncoding")) {
            this.fontSpecific = false;
        }
        if (!this.encoding.startsWith("#")) {
            PdfEncodings.convertToBytes(" ", string2);
        }
        this.createEncoding();
    }

    int getRawWidth(int n, String string) {
        Object[] objectArray;
        if (string == null) {
            objectArray = (Object[])this.CharMetrics.get(new Integer(n));
        } else {
            if (string.equals(".notdef")) {
                return 0;
            }
            objectArray = (Object[])this.CharMetrics.get(string);
        }
        if (objectArray != null) {
            return (Integer)objectArray[1];
        }
        return 0;
    }

    public int getKerning(int n, int n2) {
        String string = GlyphList.unicodeToName(n);
        if (string == null) {
            return 0;
        }
        String string2 = GlyphList.unicodeToName(n2);
        if (string2 == null) {
            return 0;
        }
        Object[] objectArray = (Object[])this.KernPairs.get(string);
        if (objectArray == null) {
            return 0;
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!string2.equals(objectArray[i])) continue;
            return (Integer)objectArray[i + 1];
        }
        return 0;
    }

    public void process(RandomAccessFileOrArray randomAccessFileOrArray) throws DocumentException, IOException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4;
        String string2;
        boolean bl = false;
        while ((string2 = randomAccessFileOrArray.readLine()) != null) {
            object4 = new StringTokenizer(string2, " ,\n\r\t\f");
            if (!((StringTokenizer)object4).hasMoreTokens()) continue;
            string = ((StringTokenizer)object4).nextToken();
            if (string.equals("FontName")) {
                this.FontName = ((StringTokenizer)object4).nextToken("\u00ff").substring(1);
                continue;
            }
            if (string.equals("FullName")) {
                this.FullName = ((StringTokenizer)object4).nextToken("\u00ff").substring(1);
                continue;
            }
            if (string.equals("FamilyName")) {
                this.FamilyName = ((StringTokenizer)object4).nextToken("\u00ff").substring(1);
                continue;
            }
            if (string.equals("Weight")) {
                this.Weight = ((StringTokenizer)object4).nextToken("\u00ff").substring(1);
                continue;
            }
            if (string.equals("ItalicAngle")) {
                this.ItalicAngle = Float.parseFloat(((StringTokenizer)object4).nextToken());
                continue;
            }
            if (string.equals("IsFixedPitch")) {
                this.IsFixedPitch = ((StringTokenizer)object4).nextToken().equals("true");
                continue;
            }
            if (string.equals("CharacterSet")) {
                this.CharacterSet = ((StringTokenizer)object4).nextToken("\u00ff").substring(1);
                continue;
            }
            if (string.equals("FontBBox")) {
                this.llx = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                this.lly = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                this.urx = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                this.ury = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                continue;
            }
            if (string.equals("UnderlinePosition")) {
                this.UnderlinePosition = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                continue;
            }
            if (string.equals("UnderlineThickness")) {
                this.UnderlineThickness = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                continue;
            }
            if (string.equals("EncodingScheme")) {
                this.EncodingScheme = ((StringTokenizer)object4).nextToken("\u00ff").substring(1);
                continue;
            }
            if (string.equals("CapHeight")) {
                this.CapHeight = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                continue;
            }
            if (string.equals("XHeight")) {
                this.XHeight = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                continue;
            }
            if (string.equals("Ascender")) {
                this.Ascender = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                continue;
            }
            if (string.equals("Descender")) {
                this.Descender = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                continue;
            }
            if (string.equals("StdHW")) {
                this.StdHW = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                continue;
            }
            if (string.equals("StdVW")) {
                this.StdVW = (int)Float.parseFloat(((StringTokenizer)object4).nextToken());
                continue;
            }
            if (!string.equals("StartCharMetrics")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new DocumentException("Missing StartCharMetrics in " + this.fileName);
        }
        while ((string2 = randomAccessFileOrArray.readLine()) != null) {
            Object[] objectArray2;
            object4 = new StringTokenizer(string2);
            if (!((StringTokenizer)object4).hasMoreTokens()) continue;
            string = ((StringTokenizer)object4).nextToken();
            if (string.equals("EndCharMetrics")) {
                bl = false;
                break;
            }
            object3 = new Integer(-1);
            object2 = new Integer(250);
            object = "";
            objectArray = null;
            object4 = new StringTokenizer(string2, ";");
            while (((StringTokenizer)object4).hasMoreTokens()) {
                objectArray2 = new StringTokenizer(((StringTokenizer)object4).nextToken());
                if (!objectArray2.hasMoreTokens()) continue;
                string = objectArray2.nextToken();
                if (string.equals("C")) {
                    object3 = Integer.valueOf(objectArray2.nextToken());
                    continue;
                }
                if (string.equals("WX")) {
                    object2 = new Integer((int)Float.parseFloat(objectArray2.nextToken()));
                    continue;
                }
                if (string.equals("N")) {
                    object = objectArray2.nextToken();
                    continue;
                }
                if (!string.equals("B")) continue;
                objectArray = new int[]{Integer.parseInt(objectArray2.nextToken()), Integer.parseInt(objectArray2.nextToken()), Integer.parseInt(objectArray2.nextToken()), Integer.parseInt(objectArray2.nextToken())};
            }
            objectArray2 = new Object[]{object3, object2, object, objectArray};
            if ((Integer)object3 >= 0) {
                this.CharMetrics.put(object3, objectArray2);
            }
            this.CharMetrics.put(object, objectArray2);
        }
        if (bl) {
            throw new DocumentException("Missing EndCharMetrics in " + this.fileName);
        }
        if (!this.CharMetrics.containsKey("nonbreakingspace") && (object4 = (Object[])this.CharMetrics.get("space")) != null) {
            this.CharMetrics.put("nonbreakingspace", object4);
        }
        while ((string2 = randomAccessFileOrArray.readLine()) != null) {
            object4 = new StringTokenizer(string2);
            if (!((StringTokenizer)object4).hasMoreTokens()) continue;
            string = ((StringTokenizer)object4).nextToken();
            if (string.equals("EndFontMetrics")) {
                return;
            }
            if (!string.equals("StartKernPairs")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new DocumentException("Missing EndFontMetrics in " + this.fileName);
        }
        while ((string2 = randomAccessFileOrArray.readLine()) != null) {
            object4 = new StringTokenizer(string2);
            if (!((StringTokenizer)object4).hasMoreTokens()) continue;
            string = ((StringTokenizer)object4).nextToken();
            if (string.equals("KPX")) {
                object3 = ((StringTokenizer)object4).nextToken();
                object2 = ((StringTokenizer)object4).nextToken();
                object = new Integer((int)Float.parseFloat(((StringTokenizer)object4).nextToken()));
                objectArray = (Object[])this.KernPairs.get(object3);
                if (objectArray == null) {
                    this.KernPairs.put(object3, new Object[]{object2, object});
                    continue;
                }
                int n = objectArray.length;
                Object[] objectArray3 = new Object[n + 2];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                objectArray3[n] = object2;
                objectArray3[n + 1] = object;
                this.KernPairs.put(object3, objectArray3);
                continue;
            }
            if (!string.equals("EndKernPairs")) continue;
            bl = false;
            break;
        }
        if (bl) {
            throw new DocumentException("Missing EndKernPairs in " + this.fileName);
        }
        randomAccessFileOrArray.close();
    }

    public PdfStream getFullFontStream() throws DocumentException {
        if (this.builtinFont || !this.embedded) {
            return null;
        }
        RandomAccessFileOrArray randomAccessFileOrArray = null;
        try {
            String string = this.fileName.substring(0, this.fileName.length() - 3) + "pfb";
            randomAccessFileOrArray = this.pfb == null ? new RandomAccessFileOrArray(string, true, Document.plainRandomAccess) : new RandomAccessFileOrArray(this.pfb);
            int n = randomAccessFileOrArray.length();
            byte[] byArray = new byte[n - 18];
            int[] nArray = new int[3];
            int n2 = 0;
            for (int i = 0; i < 3; ++i) {
                if (randomAccessFileOrArray.read() != 128) {
                    throw new DocumentException("Start marker missing in " + string);
                }
                if (randomAccessFileOrArray.read() != PFB_TYPES[i]) {
                    throw new DocumentException("Incorrect segment type in " + string);
                }
                int n3 = randomAccessFileOrArray.read();
                n3 += randomAccessFileOrArray.read() << 8;
                n3 += randomAccessFileOrArray.read() << 16;
                nArray[i] = n3 += randomAccessFileOrArray.read() << 24;
                while (n3 != 0) {
                    int n4 = randomAccessFileOrArray.read(byArray, n2, n3);
                    if (n4 < 0) {
                        throw new DocumentException("Premature end in " + string);
                    }
                    n2 += n4;
                    n3 -= n4;
                }
            }
            BaseFont.StreamFont streamFont = new BaseFont.StreamFont(byArray, nArray, this.compressionLevel);
            return streamFont;
        }
        catch (Exception exception) {
            throw new DocumentException(exception);
        }
        finally {
            if (randomAccessFileOrArray != null) {
                try {
                    randomAccessFileOrArray.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private PdfDictionary getFontDescriptor(PdfIndirectReference pdfIndirectReference) {
        if (this.builtinFont) {
            return null;
        }
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONTDESCRIPTOR);
        pdfDictionary.put(PdfName.ASCENT, new PdfNumber(this.Ascender));
        pdfDictionary.put(PdfName.CAPHEIGHT, new PdfNumber(this.CapHeight));
        pdfDictionary.put(PdfName.DESCENT, new PdfNumber(this.Descender));
        pdfDictionary.put(PdfName.FONTBBOX, new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        pdfDictionary.put(PdfName.FONTNAME, new PdfName(this.FontName));
        pdfDictionary.put(PdfName.ITALICANGLE, new PdfNumber(this.ItalicAngle));
        pdfDictionary.put(PdfName.STEMV, new PdfNumber(this.StdVW));
        if (pdfIndirectReference != null) {
            pdfDictionary.put(PdfName.FONTFILE, pdfIndirectReference);
        }
        int n = 0;
        if (this.IsFixedPitch) {
            n |= 1;
        }
        n |= this.fontSpecific ? 4 : 32;
        if (this.ItalicAngle < 0.0f) {
            n |= 0x40;
        }
        if (this.FontName.indexOf("Caps") >= 0 || this.FontName.endsWith("SC")) {
            n |= 0x20000;
        }
        if (this.Weight.equals("Bold")) {
            n |= 0x40000;
        }
        pdfDictionary.put(PdfName.FLAGS, new PdfNumber(n));
        return pdfDictionary;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference pdfIndirectReference, int n, int n2, byte[] byArray) {
        boolean bl;
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        pdfDictionary.put(PdfName.SUBTYPE, PdfName.TYPE1);
        pdfDictionary.put(PdfName.BASEFONT, new PdfName(this.FontName));
        boolean bl2 = bl = this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman");
        if (!this.fontSpecific || this.specialMap != null) {
            for (int i = n; i <= n2; ++i) {
                if (this.differences[i].equals(".notdef")) continue;
                n = i;
                break;
            }
            if (bl) {
                pdfDictionary.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.ENCODING);
                PdfArray pdfArray = new PdfArray();
                boolean bl3 = true;
                for (int i = n; i <= n2; ++i) {
                    if (byArray[i] != 0) {
                        if (bl3) {
                            pdfArray.add(new PdfNumber(i));
                            bl3 = false;
                        }
                        pdfArray.add(new PdfName(this.differences[i]));
                        continue;
                    }
                    bl3 = true;
                }
                pdfDictionary2.put(PdfName.DIFFERENCES, pdfArray);
                pdfDictionary.put(PdfName.ENCODING, pdfDictionary2);
            }
        }
        if (this.specialMap != null || this.forceWidthsOutput || !this.builtinFont || !this.fontSpecific && !bl) {
            pdfDictionary.put(PdfName.FIRSTCHAR, new PdfNumber(n));
            pdfDictionary.put(PdfName.LASTCHAR, new PdfNumber(n2));
            PdfArray pdfArray = new PdfArray();
            for (int i = n; i <= n2; ++i) {
                if (byArray[i] == 0) {
                    pdfArray.add(new PdfNumber(0));
                    continue;
                }
                pdfArray.add(new PdfNumber(this.widths[i]));
            }
            pdfDictionary.put(PdfName.WIDTHS, pdfArray);
        }
        if (!this.builtinFont && pdfIndirectReference != null) {
            pdfDictionary.put(PdfName.FONTDESCRIPTOR, pdfIndirectReference);
        }
        return pdfDictionary;
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        boolean bl;
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        byte[] byArray = (byte[])objectArray[2];
        boolean bl2 = bl = (Boolean)objectArray[3] != false && this.subset;
        if (!bl) {
            n = 0;
            n2 = byArray.length - 1;
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 1;
            }
        }
        PdfIndirectReference pdfIndirectReference2 = null;
        PdfDictionary pdfDictionary = null;
        PdfIndirectObject pdfIndirectObject = null;
        pdfDictionary = this.getFullFontStream();
        if (pdfDictionary != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        if ((pdfDictionary = this.getFontDescriptor(pdfIndirectReference2)) != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        pdfDictionary = this.getFontBaseType(pdfIndirectReference2, n, n2, byArray);
        pdfWriter.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
    }

    public float getFontDescriptor(int n, float f) {
        switch (n) {
            case 1: 
            case 9: {
                return (float)this.Ascender * f / 1000.0f;
            }
            case 2: {
                return (float)this.CapHeight * f / 1000.0f;
            }
            case 3: 
            case 10: {
                return (float)this.Descender * f / 1000.0f;
            }
            case 4: {
                return this.ItalicAngle;
            }
            case 5: {
                return (float)this.llx * f / 1000.0f;
            }
            case 6: {
                return (float)this.lly * f / 1000.0f;
            }
            case 7: {
                return (float)this.urx * f / 1000.0f;
            }
            case 8: {
                return (float)this.ury * f / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (float)(this.urx - this.llx) * f / 1000.0f;
            }
            case 13: {
                return (float)this.UnderlinePosition * f / 1000.0f;
            }
            case 14: {
                return (float)this.UnderlineThickness * f / 1000.0f;
            }
        }
        return 0.0f;
    }

    public String getPostscriptFontName() {
        return this.FontName;
    }

    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.FullName}};
    }

    public String[][] getAllNameEntries() {
        return new String[][]{{"4", "", "", "", this.FullName}};
    }

    public String[][] getFamilyFontName() {
        return new String[][]{{"", "", "", this.FamilyName}};
    }

    public boolean hasKernPairs() {
        return !this.KernPairs.isEmpty();
    }

    public void setPostscriptFontName(String string) {
        this.FontName = string;
    }

    public boolean setKerning(int n, int n2, int n3) {
        int n4;
        String string = GlyphList.unicodeToName(n);
        if (string == null) {
            return false;
        }
        String string2 = GlyphList.unicodeToName(n2);
        if (string2 == null) {
            return false;
        }
        Object[] objectArray = (Object[])this.KernPairs.get(string);
        if (objectArray == null) {
            objectArray = new Object[]{string2, new Integer(n3)};
            this.KernPairs.put(string, objectArray);
            return true;
        }
        for (n4 = 0; n4 < objectArray.length; n4 += 2) {
            if (!string2.equals(objectArray[n4])) continue;
            objectArray[n4 + 1] = new Integer(n3);
            return true;
        }
        n4 = objectArray.length;
        Object[] objectArray2 = new Object[n4 + 2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n4);
        objectArray2[n4] = string2;
        objectArray2[n4 + 1] = new Integer(n3);
        this.KernPairs.put(string, objectArray2);
        return true;
    }

    protected int[] getRawCharBBox(int n, String string) {
        Object[] objectArray;
        if (string == null) {
            objectArray = (Object[])this.CharMetrics.get(new Integer(n));
        } else {
            if (string.equals(".notdef")) {
                return null;
            }
            objectArray = (Object[])this.CharMetrics.get(string);
        }
        if (objectArray != null) {
            return (int[])objectArray[3];
        }
        return null;
    }

    static {
        PFB_TYPES = new int[]{1, 2, 1};
    }
}

