/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.Map;
import net.sf.jasperreports.engine.fill.TextLayoutLine;
import net.sf.jasperreports.engine.fill.TextLine;
import net.sf.jasperreports.engine.fill.TextLineWrapper;
import net.sf.jasperreports.engine.fill.TextMeasureContext;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.MaxFontSizeFinder;

public class ComplexTextLineWrapper
implements TextLineWrapper {
    private TextMeasureContext context;
    private MaxFontSizeFinder maxFontSizeFinder;
    private AttributedCharacterIterator allParagraphs;
    private Map<AttributedCharacterIterator.Attribute, Object> globalAttributes;
    private AttributedCharacterIterator paragraph;
    private LineBreakMeasurer lineMeasurer;

    public ComplexTextLineWrapper() {
    }

    protected ComplexTextLineWrapper(ComplexTextLineWrapper parent) {
        this.context = parent.context;
        this.maxFontSizeFinder = parent.maxFontSizeFinder;
        this.allParagraphs = parent.allParagraphs;
        this.globalAttributes = parent.globalAttributes;
    }

    @Override
    public void init(TextMeasureContext context) {
        this.context = context;
        boolean isStyledText = !"none".equals(context.getElement().getMarkup());
        this.maxFontSizeFinder = MaxFontSizeFinder.getInstance(isStyledText);
    }

    @Override
    public boolean start(JRStyledText styledText) {
        this.globalAttributes = styledText.getGlobalAttributes();
        this.allParagraphs = styledText.getAwtAttributedString(this.context.getJasperReportsContext(), this.context.isIgnoreMissingFont()).getIterator();
        return true;
    }

    @Override
    public void startParagraph(int paragraphStart, int paragraphEnd, boolean truncateAtChar) {
        AttributedCharacterIterator paragraph = new AttributedString(this.allParagraphs, paragraphStart, paragraphEnd).getIterator();
        this.startParagraph(paragraph, truncateAtChar);
    }

    @Override
    public void startEmptyParagraph(int paragraphStart) {
        Map<AttributedCharacterIterator.Attribute, Object> attributes = new AttributedString(this.allParagraphs, paragraphStart, paragraphStart + 1).getIterator().getAttributes();
        AttributedCharacterIterator paragraph = new AttributedString(" ", attributes).getIterator();
        this.startParagraph(paragraph, false);
    }

    protected void startParagraph(AttributedCharacterIterator paragraph, boolean truncateAtChar) {
        this.paragraph = paragraph;
        BreakIterator breakIt = truncateAtChar ? BreakIterator.getCharacterInstance() : BreakIterator.getLineInstance();
        this.lineMeasurer = new LineBreakMeasurer(paragraph, breakIt, this.context.getFontRenderContext());
    }

    @Override
    public int paragraphPosition() {
        return this.lineMeasurer.getPosition();
    }

    @Override
    public int paragraphEnd() {
        return this.paragraph.getEndIndex();
    }

    @Override
    public TextLine nextLine(float width, int endLimit, boolean requireWord) {
        TextLayout textLayout = this.lineMeasurer.nextLayout(width, endLimit, requireWord);
        return textLayout == null ? null : new TextLayoutLine(textLayout);
    }

    @Override
    public TextLine baseTextLine(int index) {
        AttributedString tmpText = new AttributedString(this.paragraph, index, index + 1);
        LineBreakMeasurer lbm = new LineBreakMeasurer(tmpText.getIterator(), this.context.getFontRenderContext());
        TextLayout tlyt = lbm.nextLayout(100.0f);
        return new TextLayoutLine(tlyt);
    }

    @Override
    public float maxFontsize(int start, int end) {
        return this.maxFontSizeFinder.findMaxFontSize(new AttributedString(this.paragraph, start, end).getIterator(), this.context.getElement().getFontsize());
    }

    @Override
    public String getLineText(int start, int end) {
        StringBuilder lineText = new StringBuilder();
        this.allParagraphs.setIndex(start);
        while (this.allParagraphs.getIndex() < end && this.allParagraphs.current() != '\n') {
            lineText.append(this.allParagraphs.current());
            this.allParagraphs.next();
        }
        return lineText.toString();
    }

    @Override
    public char charAt(int index) {
        return this.allParagraphs.setIndex(index);
    }

    @Override
    public TextLineWrapper lastLineWrapper(String lineText, int start, int textLength, boolean truncateAtChar) {
        AttributedString attributedText = new AttributedString(lineText);
        AttributedCharacterIterator textAttributes = new AttributedString(this.allParagraphs, start, start + textLength).getIterator();
        this.setAttributes(attributedText, textAttributes, 0);
        this.setAttributes(attributedText, this.globalAttributes, textLength, lineText.length());
        AttributedCharacterIterator lineParagraph = attributedText.getIterator();
        ComplexTextLineWrapper lastLineWrapper = new ComplexTextLineWrapper(this);
        lastLineWrapper.startParagraph(lineParagraph, truncateAtChar);
        return lastLineWrapper;
    }

    protected void setAttributes(AttributedString string, AttributedCharacterIterator attributes, int stringOffset) {
        char c = attributes.first();
        while (c != '\uffff') {
            for (Map.Entry<AttributedCharacterIterator.Attribute, Object> attributeEntry : attributes.getAttributes().entrySet()) {
                AttributedCharacterIterator.Attribute attribute = attributeEntry.getKey();
                if (attributes.getRunStart(attribute) != attributes.getIndex()) continue;
                Object attributeValue = attributeEntry.getValue();
                string.addAttribute(attribute, attributeValue, attributes.getIndex() + stringOffset, attributes.getRunLimit(attribute) + stringOffset);
            }
            c = attributes.next();
        }
    }

    protected void setAttributes(AttributedString string, Map<AttributedCharacterIterator.Attribute, Object> attributes, int startIndex, int endIndex) {
        for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : attributes.entrySet()) {
            AttributedCharacterIterator.Attribute attribute = entry.getKey();
            Object attributeValue = entry.getValue();
            string.addAttribute(attribute, attributeValue, startIndex, endIndex);
        }
    }
}

