/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.CommonReturnValue;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.VariableReturnValue;
import net.sf.jasperreports.engine.fill.FillReturnValues;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.type.CalculationEnum;

public abstract class AbstractVariableReturnValueSourceContext
implements FillReturnValues.SourceContext {
    public static final String EXCEPTION_MESSAGE_KEY_NUMERIC_TYPE_REQUIRED = "fill.return.values.numeric.type.required";
    public static final String EXCEPTION_MESSAGE_KEY_SOURCE_NOT_FOUND = "fill.return.values.source.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_VARIABLE_NOT_ASSIGNABLE = "fill.return.values.variable.not.assignable";

    @Override
    public void check(CommonReturnValue commonReturnValue) throws JRException {
        VariableReturnValue returnValue = (VariableReturnValue)commonReturnValue;
        String subreportVariableName = returnValue.getFromVariable();
        JRVariable subrepVariable = this.getFromVariable(subreportVariableName);
        if (subrepVariable == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_SOURCE_NOT_FOUND, subreportVariableName, returnValue.getToVariable());
        }
        JRFillVariable variable = this.getToVariable(returnValue.getToVariable());
        if (returnValue.getCalculation() == CalculationEnum.COUNT || returnValue.getCalculation() == CalculationEnum.DISTINCT_COUNT) {
            if (!Number.class.isAssignableFrom(variable.getValueClass())) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_NUMERIC_TYPE_REQUIRED, returnValue.getToVariable());
            }
        } else if (!(variable.getValueClass().isAssignableFrom(subrepVariable.getValueClass()) || Number.class.isAssignableFrom(variable.getValueClass()) && Number.class.isAssignableFrom(subrepVariable.getValueClass()))) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_VARIABLE_NOT_ASSIGNABLE, returnValue.getToVariable(), subreportVariableName);
        }
    }

    public abstract JRVariable getFromVariable(String var1);

    @Override
    public abstract JRFillVariable getToVariable(String var1);
}

