/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sf.jasperreports.charts.util.AbstractChartRenderableFactory;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.SimpleDataRenderer;
import org.opennms.shaded.jasper.org.jfree.chart.JFreeChart;

public class ImageChartRendererFactory
extends AbstractChartRenderableFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Renderable getRenderable(JasperReportsContext jasperReportsContext, JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider, Rectangle2D rectangle) {
        int dpi = JRPropertiesUtil.getInstance(jasperReportsContext).getIntegerProperty("net.sf.jasperreports.image.dpi", 72);
        double scale = (double)dpi / 72.0;
        BufferedImage bi = new BufferedImage((int)(scale * (double)((int)rectangle.getWidth())), (int)(scale * rectangle.getHeight()), 2);
        List<JRPrintImageAreaHyperlink> areaHyperlinks = null;
        Graphics2D grx = bi.createGraphics();
        try {
            grx.scale(scale, scale);
            if (chartHyperlinkProvider != null && chartHyperlinkProvider.hasHyperlinks()) {
                areaHyperlinks = ChartUtil.getImageAreaHyperlinks(chart, chartHyperlinkProvider, grx, rectangle);
            } else {
                chart.draw(grx, rectangle);
            }
        }
        finally {
            grx.dispose();
        }
        try {
            return new SimpleDataRenderer(JRImageLoader.getInstance(jasperReportsContext).loadBytesFromAwtImage(bi, ImageTypeEnum.PNG), areaHyperlinks);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }
}

