/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import io.netty.buffer.ByteBuf;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.CounterData;

public class VirtNode
implements CounterData {
    public final long mhz;
    public final long cpus;
    public final UnsignedLong memory;
    public final UnsignedLong memory_free;
    public final long num_domains;

    public VirtNode(ByteBuf buffer) throws InvalidPacketException {
        this.mhz = BufferUtils.uint32((ByteBuf)buffer);
        this.cpus = BufferUtils.uint32((ByteBuf)buffer);
        this.memory = BufferUtils.uint64((ByteBuf)buffer);
        this.memory_free = BufferUtils.uint64((ByteBuf)buffer);
        this.num_domains = BufferUtils.uint32((ByteBuf)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mhz", this.mhz).add("cpus", this.cpus).add("memory", (Object)this.memory).add("memory_free", (Object)this.memory_free).add("num_domains", this.num_domains).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("mhz", this.mhz);
        bsonWriter.writeInt64("cpus", this.cpus);
        bsonWriter.writeInt64("memory", this.memory.longValue());
        bsonWriter.writeInt64("memory_free", this.memory_free.longValue());
        bsonWriter.writeInt64("num_domains", this.num_domains);
        bsonWriter.writeEndDocument();
    }
}

