/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.finitestates;

import com.atomikos.finitestates.FSM;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.finitestates.FSMPreTransitionListener;
import com.atomikos.finitestates.FSMTransitionEvent;
import com.atomikos.finitestates.FSMTransitionListener;
import com.atomikos.finitestates.TransitionTable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;

public class FSMImp<Status>
implements FSM<Status> {
    private Status state_ = null;
    private Hashtable<Status, Hashtable<EventListener, Object>> enterlisteners_ = null;
    private Hashtable<Status, Hashtable<EventListener, Object>> preenterlisteners_ = null;
    private Hashtable<Status, Hashtable<EventListener, Object>> transitionlisteners_ = null;
    private Hashtable<Status, Hashtable<EventListener, Object>> pretransitionlisteners_ = null;
    private TransitionTable<Status> transitiontable_ = null;
    private Object eventsource_ = null;
    private Object stateLatch_;

    public FSMImp(TransitionTable<Status> transitiontable, Status initialstate) {
        this(null, transitiontable, initialstate);
        this.eventsource_ = this;
    }

    public FSMImp(Object eventsource, TransitionTable<Status> transitiontable, Status initialstate) {
        this.transitiontable_ = transitiontable;
        this.state_ = initialstate;
        this.enterlisteners_ = new Hashtable();
        this.preenterlisteners_ = new Hashtable();
        this.transitionlisteners_ = new Hashtable();
        this.pretransitionlisteners_ = new Hashtable();
        this.eventsource_ = eventsource;
        this.stateLatch_ = new Object();
    }

    protected synchronized void addEnterListener(Hashtable<Status, Hashtable<EventListener, Object>> listeners, EventListener lstnr, Status state) {
        Hashtable<EventListener, Object> lstnrs = listeners.get(state);
        if (lstnrs == null) {
            lstnrs = new Hashtable();
        }
        if (!lstnrs.containsKey(lstnr)) {
            lstnrs.put(lstnr, new Object());
        }
        listeners.put(state, lstnrs);
    }

    protected synchronized void addTransitionListener(Hashtable listeners, Object lstnr, Status from, Status to) {
        Hashtable<Object, Object> tolstnrs;
        Hashtable lstnrs = (Hashtable)listeners.get(from);
        if (lstnrs == null) {
            lstnrs = new Hashtable();
        }
        if ((tolstnrs = (Hashtable<Object, Object>)lstnrs.get(to)) == null) {
            tolstnrs = new Hashtable<Object, Object>();
        }
        if (!tolstnrs.containsKey(lstnr)) {
            tolstnrs.put(lstnr, new Object());
        }
        lstnrs.put(to, tolstnrs);
        listeners.put(from, lstnrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(Hashtable<Status, Hashtable<EventListener, Object>> listeners, Status state, boolean pre) {
        Hashtable lstnrs = null;
        FSMEnterEvent<Status> event = new FSMEnterEvent<Status>(this.eventsource_, state);
        FSMImp fSMImp = this;
        synchronized (fSMImp) {
            lstnrs = listeners.get(state);
            if (lstnrs == null) {
                return;
            }
            lstnrs = (Hashtable)lstnrs.clone();
        }
        Enumeration enumm = lstnrs.keys();
        while (enumm.hasMoreElements()) {
            EventListener listener = (EventListener)enumm.nextElement();
            if (pre && listener instanceof FSMPreEnterListener) {
                ((FSMPreEnterListener)listener).preEnter(event);
                continue;
            }
            if (pre || !(listener instanceof FSMEnterListener)) continue;
            ((FSMEnterListener)listener).entered(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(Hashtable<Status, Hashtable<EventListener, Object>> listeners, Status from, Status to, boolean pre) {
        FSMTransitionEvent<Status> event = new FSMTransitionEvent<Status>(this.eventsource_, from, to);
        Hashtable lstnrs = null;
        Hashtable tolstnrs = null;
        FSMImp fSMImp = this;
        synchronized (fSMImp) {
            lstnrs = listeners.get(from);
            if (lstnrs == null) {
                return;
            }
            tolstnrs = (Hashtable)lstnrs.get(to);
            if (tolstnrs == null) {
                return;
            }
            lstnrs = (Hashtable)lstnrs.clone();
            tolstnrs = (Hashtable)tolstnrs.clone();
        }
        Enumeration enumm = tolstnrs.keys();
        while (enumm.hasMoreElements()) {
            Object listener = enumm.nextElement();
            if (pre && listener instanceof FSMPreTransitionListener) {
                ((FSMPreTransitionListener)listener).beforeTransition(event);
                continue;
            }
            if (pre || !(listener instanceof FSMTransitionListener)) continue;
            ((FSMTransitionListener)listener).transitionPerformed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status getState() {
        Status ret = null;
        Object object = this.stateLatch_;
        synchronized (object) {
            ret = this.state_;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStateObject(Status state) {
        Object object = this.stateLatch_;
        synchronized (object) {
            this.state_ = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(Status state) throws IllegalStateException {
        Status oldstate = null;
        FSMImp fSMImp = this;
        synchronized (fSMImp) {
            if (!this.transitiontable_.legalTransition(this.state_, state)) {
                throw new IllegalStateException("Transition not allowed: " + this.state_ + " to " + state);
            }
            oldstate = this.state_;
            this.notifyListeners(this.preenterlisteners_, state, true);
            this.notifyListeners(this.pretransitionlisteners_, oldstate, state, true);
            this.setStateObject(state);
        }
        this.notifyListeners(this.enterlisteners_, state, false);
        this.notifyListeners(this.transitionlisteners_, oldstate, state, false);
    }

    @Override
    public void addFSMEnterListener(FSMEnterListener<Status> lstnr, Status state) {
        this.addEnterListener(this.enterlisteners_, lstnr, state);
    }

    @Override
    public void addFSMPreEnterListener(FSMPreEnterListener<Status> lstnr, Status state) {
        this.addEnterListener(this.preenterlisteners_, lstnr, state);
    }

    @Override
    public void addFSMTransitionListener(FSMTransitionListener<Status> lstnr, Status from, Status to) {
        this.addTransitionListener(this.transitionlisteners_, lstnr, from, to);
    }

    @Override
    public void addFSMPreTransitionListener(FSMPreTransitionListener<Status> lstnr, Status from, Status to) {
        this.addTransitionListener(this.pretransitionlisteners_, lstnr, from, to);
    }
}

