/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.transport;

import java.net.InetAddress;
import java.time.Duration;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.RecordEnrichment;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.MessageBuilder;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.MessageUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.Direction;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.FlowMessage;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.NetflowVersion;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.SamplingAlgorithm;

public class Netflow5MessageBuilder
implements MessageBuilder {
    @Override
    public FlowMessage.Builder buildMessage(Iterable<Value<?>> values, RecordEnrichment enrichment) {
        FlowMessage.Builder builder = FlowMessage.newBuilder();
        long unixSecs = 0L;
        long unixNSecs = 0L;
        long sysUpTime = 0L;
        long first = 0L;
        long last = 0L;
        InetAddress srcAddr = null;
        InetAddress dstAddr = null;
        InetAddress nextHop = null;
        for (Value<?> value : values) {
            switch (value.getName()) {
                case "@count": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setNumFlowRecords(arg_0));
                    break;
                }
                case "@unixSecs": {
                    unixSecs = MessageUtils.getLongValue(value);
                    break;
                }
                case "@unixNSecs": {
                    unixNSecs = MessageUtils.getLongValue(value);
                    break;
                }
                case "@sysUptime": {
                    sysUpTime = MessageUtils.getLongValue(value);
                    break;
                }
                case "@flowSequence": {
                    MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setFlowSeqNum(arg_0));
                    break;
                }
                case "@engineType": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setEngineType(arg_0));
                    break;
                }
                case "@engineId": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setEngineId(arg_0));
                    break;
                }
                case "@samplingAlgorithm": {
                    builder.setSamplingAlgorithm(Netflow5MessageBuilder.getSamplingAlgorithm(value));
                    break;
                }
                case "@samplingInterval": {
                    MessageUtils.getDoubleValue(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setSamplingInterval(arg_0));
                    break;
                }
                case "srcAddr": {
                    srcAddr = MessageUtils.getInetAddress(value);
                    break;
                }
                case "dstAddr": {
                    dstAddr = MessageUtils.getInetAddress(value);
                    break;
                }
                case "nextHop": {
                    nextHop = MessageUtils.getInetAddress(value);
                    break;
                }
                case "input": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setInputSnmpIfindex(arg_0));
                    break;
                }
                case "output": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setOutputSnmpIfindex(arg_0));
                    break;
                }
                case "dPkts": {
                    MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setNumPackets(arg_0));
                    break;
                }
                case "dOctets": {
                    MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setNumBytes(arg_0));
                    break;
                }
                case "first": {
                    first = MessageUtils.getLongValue(value);
                    break;
                }
                case "last": {
                    last = MessageUtils.getLongValue(value);
                    break;
                }
                case "srcPort": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setSrcPort(arg_0));
                    break;
                }
                case "dstPort": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setDstPort(arg_0));
                    break;
                }
                case "tcpFlags": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setTcpFlags(arg_0));
                    break;
                }
                case "proto": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setProtocol(arg_0));
                    break;
                }
                case "srcAs": {
                    MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setSrcAs(arg_0));
                    break;
                }
                case "dstAs": {
                    MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setDstAs(arg_0));
                    break;
                }
                case "tos": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setTos(arg_0));
                    break;
                }
                case "srcMask": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setSrcMaskLen(arg_0));
                    break;
                }
                case "dstMask": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setDstMaskLen(arg_0));
                    break;
                }
                case "egress": {
                    boolean egress = MessageUtils.getBooleanValue(value);
                    Direction direction = egress ? Direction.EGRESS : Direction.INGRESS;
                    builder.setDirection(direction);
                    break;
                }
            }
        }
        long timeStamp = Duration.ofSeconds(unixSecs, unixNSecs).toMillis();
        long bootTime = timeStamp - sysUpTime;
        builder.setNetflowVersion(NetflowVersion.V5);
        builder.setFirstSwitched(MessageUtils.setLongValue(bootTime + first));
        builder.setLastSwitched(MessageUtils.setLongValue(bootTime + last));
        builder.setTimestamp(timeStamp);
        if (srcAddr != null) {
            builder.setSrcAddress(srcAddr.getHostAddress());
            enrichment.getHostnameFor(srcAddr).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setSrcHostname(arg_0));
        }
        if (dstAddr != null) {
            builder.setDstAddress(dstAddr.getHostAddress());
            enrichment.getHostnameFor(dstAddr).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setDstHostname(arg_0));
        }
        if (nextHop != null) {
            builder.setNextHopAddress(nextHop.getHostAddress());
            enrichment.getHostnameFor(nextHop).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setNextHopHostname(arg_0));
        }
        return builder;
    }

    private static SamplingAlgorithm getSamplingAlgorithm(Value<?> value) {
        Long saValue = MessageUtils.getLongValue(value);
        SamplingAlgorithm samplingAlgorithm = SamplingAlgorithm.UNASSIGNED;
        if (saValue != null) {
            switch (saValue.intValue()) {
                case 1: {
                    samplingAlgorithm = SamplingAlgorithm.SYSTEMATIC_COUNT_BASED_SAMPLING;
                    break;
                }
                case 2: {
                    samplingAlgorithm = SamplingAlgorithm.RANDOM_N_OUT_OF_N_SAMPLING;
                    break;
                }
            }
        }
        return samplingAlgorithm;
    }
}

