/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.MissingTemplateException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.SequenceNumberTracker;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Template;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.state.ExporterState;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.state.OptionState;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.state.ParserState;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.state.TemplateState;

public class UdpSessionManager {
    final ConcurrentMap<TemplateKey, TimeWrapper<TemplateOptions>> templates = Maps.newConcurrentMap();
    private final Map<DomainKey, SequenceNumberTracker> sequenceNumbers = Maps.newConcurrentMap();
    private final Duration timeout;
    private final Supplier<SequenceNumberTracker> sequenceNumberTracker;

    public UdpSessionManager(Duration timeout, Supplier<SequenceNumberTracker> sequenceNumberTracker) {
        this.timeout = timeout;
        this.sequenceNumberTracker = Objects.requireNonNull(sequenceNumberTracker);
    }

    public void doHousekeeping() {
        Instant timeout = Instant.now().minus(this.timeout);
        this.removeTemplateIf(e -> ((TimeWrapper)e.getValue()).time.isBefore(timeout));
    }

    private void removeTemplateIf(Predicate<Map.Entry<TemplateKey, TimeWrapper<TemplateOptions>>> predicate) {
        this.templates.entrySet().removeIf(predicate);
    }

    public Session getSession(SessionKey sessionKey) {
        return new UdpSession(sessionKey);
    }

    public void drop(SessionKey sessionKey) {
        this.removeTemplateIf(e -> Objects.equals(((TemplateKey)e.getKey()).observationDomainId.sessionKey, sessionKey));
    }

    public int count() {
        return this.templates.size();
    }

    public Object dumpInternalState() {
        ParserState.Builder parser = ParserState.builder();
        Map<DomainKey, List<Map.Entry>> sessions = this.templates.entrySet().stream().collect(Collectors.groupingBy(e -> ((TemplateKey)e.getKey()).observationDomainId));
        for (Map.Entry<DomainKey, List<Map.Entry>> entry : sessions.entrySet()) {
            String key = String.format("%s#%s", entry.getKey().sessionKey.getDescription(), entry.getKey().observationDomainId);
            ExporterState.Builder exporter = ExporterState.builder(key);
            entry.getValue().forEach(e -> {
                exporter.withTemplate(TemplateState.builder(((TemplateKey)e.getKey()).templateId).withInsertionTime(((TimeWrapper)e.getValue()).time));
                ((TemplateOptions)((TimeWrapper)e.getValue()).wrapped).options.forEach((selectors, values) -> exporter.withOptions(OptionState.builder(((TemplateKey)e.getKey()).templateId).withInsertionTime(values.time).withSelectors((Iterable<Value<?>>)selectors).withValues((Iterable)values.wrapped)));
            });
            parser.withExporter(exporter);
        }
        return parser.build();
    }

    private final class UdpSession
    implements Session {
        private final SessionKey sessionKey;

        public UdpSession(SessionKey sessionKey) {
            this.sessionKey = Objects.requireNonNull(sessionKey);
        }

        @Override
        public void addTemplate(long observationDomainId, Template template) {
            TemplateKey key = new TemplateKey(this.sessionKey, observationDomainId, template.id);
            UdpSessionManager.this.templates.compute(key, (k, wrapper) -> {
                TemplateOptions newTemplateOptions = wrapper == null ? new TemplateOptions(template) : new TemplateOptions(template, ((TemplateOptions)wrapper.wrapped).options);
                return new TimeWrapper<TemplateOptions>(newTemplateOptions);
            });
        }

        @Override
        public void removeTemplate(long observationDomainId, int templateId) {
            TemplateKey key = new TemplateKey(this.sessionKey, observationDomainId, templateId);
            UdpSessionManager.this.templates.remove(key);
        }

        @Override
        public void removeAllTemplate(long observationDomainId, Template.Type type) {
            DomainKey domainKey = new DomainKey(this.sessionKey, observationDomainId);
            UdpSessionManager.this.removeTemplateIf(e -> domainKey.equals(((TemplateKey)e.getKey()).observationDomainId) && ((TemplateOptions)((TimeWrapper)e.getValue()).wrapped).template.type == type);
        }

        @Override
        public void addOptions(long observationDomainId, int templateId, Collection<Value<?>> scopes, List<Value<?>> values) {
            TemplateKey key = new TemplateKey(this.sessionKey, observationDomainId, templateId);
            ((TemplateOptions)((TimeWrapper)UdpSessionManager.this.templates.get((Object)key)).wrapped).options.put(new HashSet(scopes), new TimeWrapper(values));
        }

        @Override
        public Session.Resolver getResolver(long observationDomainId) {
            return new Resolver(observationDomainId);
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this.sessionKey.getRemoteAddress();
        }

        @Override
        public boolean verifySequenceNumber(long observationDomainId, long sequenceNumber) {
            DomainKey key = new DomainKey(this.sessionKey, observationDomainId);
            SequenceNumberTracker tracker = UdpSessionManager.this.sequenceNumbers.computeIfAbsent(key, k -> UdpSessionManager.this.sequenceNumberTracker.get());
            return tracker.verify(sequenceNumber);
        }

        private final class Resolver
        implements Session.Resolver {
            private final long observationDomainId;

            private Resolver(long observationDomainId) {
                this.observationDomainId = observationDomainId;
            }

            private TemplateKey key(int templateId) {
                return new TemplateKey(UdpSession.this.sessionKey, this.observationDomainId, templateId);
            }

            @Override
            public Template lookupTemplate(int templateId) throws MissingTemplateException {
                TimeWrapper templateOptions = (TimeWrapper)UdpSessionManager.this.templates.get(this.key(templateId));
                if (templateOptions != null) {
                    return ((TemplateOptions)templateOptions.wrapped).template;
                }
                throw new MissingTemplateException(templateId);
            }

            @Override
            public List<Value<?>> lookupOptions(List<Value<?>> values) {
                LinkedHashMap<String, Value> options = new LinkedHashMap<String, Value>();
                Set scoped = values.stream().map(Value::getName).collect(Collectors.toSet());
                for (Map.Entry e2 : Iterables.filter(UdpSessionManager.this.templates.entrySet(), e -> Objects.equals(((TemplateKey)e.getKey()).observationDomainId.sessionKey, UdpSession.this.sessionKey) && Objects.equals(((TemplateKey)e.getKey()).observationDomainId.observationDomainId, this.observationDomainId))) {
                    Set scopeValues;
                    TimeWrapper<List<Value<?>>> optionValues;
                    Template template = ((TemplateOptions)((TimeWrapper)e2.getValue()).wrapped).template;
                    if (!scoped.containsAll(template.scopeNames) || (optionValues = ((TemplateOptions)((TimeWrapper)e2.getValue()).wrapped).options.get(scopeValues = values.stream().filter(s -> template.scopeNames.contains(s.getName())).collect(Collectors.toSet()))) == null) continue;
                    for (Value value : (List)optionValues.wrapped) {
                        options.put(value.getName(), value);
                    }
                }
                return new ArrayList(options.values());
            }
        }
    }

    public static interface SessionKey {
        public String getDescription();

        public InetAddress getRemoteAddress();
    }

    private static final class DomainKey {
        public final SessionKey sessionKey;
        public final long observationDomainId;

        private DomainKey(SessionKey sessionKey, long observationDomainId) {
            this.sessionKey = Objects.requireNonNull(sessionKey);
            this.observationDomainId = observationDomainId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DomainKey)) {
                return false;
            }
            DomainKey that = (DomainKey)o;
            return Objects.equals(this.observationDomainId, that.observationDomainId) && Objects.equals(this.sessionKey, that.sessionKey);
        }

        public int hashCode() {
            return Objects.hash(this.sessionKey, this.observationDomainId);
        }
    }

    static final class TemplateKey {
        public final DomainKey observationDomainId;
        public final int templateId;

        TemplateKey(SessionKey sessionKey, long observationDomainId, int templateId) {
            this.observationDomainId = new DomainKey(sessionKey, observationDomainId);
            this.templateId = templateId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TemplateKey)) {
                return false;
            }
            TemplateKey that = (TemplateKey)o;
            return Objects.equals(this.observationDomainId, that.observationDomainId) && Objects.equals(this.templateId, that.templateId);
        }

        public int hashCode() {
            return Objects.hash(this.observationDomainId, this.templateId);
        }
    }

    public static final class TimeWrapper<T> {
        public final Instant time = Instant.now();
        public final T wrapped;

        private TimeWrapper(T wrapped) {
            this.wrapped = wrapped;
        }
    }

    public static class TemplateOptions {
        public final Template template;
        public final Map<Set<Value<?>>, TimeWrapper<List<Value<?>>>> options;

        public TemplateOptions(Template template) {
            this.template = Objects.requireNonNull(template);
            this.options = Maps.newConcurrentMap();
        }

        public TemplateOptions(Template template, Map<Set<Value<?>>, TimeWrapper<List<Value<?>>>> options) {
            this.template = Objects.requireNonNull(template);
            this.options = Objects.requireNonNull(options);
        }
    }
}

