/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.fileutils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opennms.core.fileutils.FileUpdateCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DotDUpdateWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(DotDUpdateWatcher.class);
    private final FileUpdateCallback callback;
    private final WatchService watcher;
    private final String directory;
    private final FilenameFilter filenameFilter;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public DotDUpdateWatcher(String directory, FilenameFilter filenameFilter, FileUpdateCallback fileUpdateCb) throws IOException {
        this.directory = directory;
        this.filenameFilter = filenameFilter;
        this.callback = fileUpdateCb;
        File file = new File(directory);
        Path path = file.toPath();
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException(String.format("directory %s doesn't exist", directory));
        }
        this.watcher = path.getFileSystem().newWatchService();
        path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        Thread thread = new Thread(new FileWatcherThread());
        thread.setName(String.format("dotDUpdateWatcher-%s", file.getName()));
        thread.start();
        LOG.info("started watcher thread for directory : {}", (Object)file.getName());
    }

    public static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public void destroy() {
        try {
            if (this.watcher != null) {
                this.watcher.close();
            }
        }
        catch (Exception e) {
            LOG.info("Exception while closing watcher", (Throwable)e);
        }
        this.closed.set(true);
    }

    private class FileWatcherThread
    implements Runnable {
        private FileWatcherThread() {
        }

        @Override
        public void run() {
            block2: while (!DotDUpdateWatcher.this.closed.get()) {
                WatchKey key = null;
                try {
                    key = DotDUpdateWatcher.this.watcher.take();
                }
                catch (Exception e) {
                    LOG.info("Watcher is either interrupted or closed", (Throwable)e);
                    break;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent ev = DotDUpdateWatcher.cast(event);
                    Path dir = (Path)key.watchable();
                    Path updatedFile = dir.resolve((Path)ev.context());
                    if (DotDUpdateWatcher.this.filenameFilter.accept(dir.toFile(), updatedFile.getFileName().toString())) {
                        LOG.info(" file {} in directory {} got updated, send callback", (Object)updatedFile.getFileName(), (Object)DotDUpdateWatcher.this.directory);
                        DotDUpdateWatcher.this.callback.reload();
                    }
                    if (key.reset()) continue;
                    continue block2;
                }
            }
        }
    }
}

