/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="downtime")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Downtime
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DELETE_ALWAYS = "always";
    public static final String DELETE_MANAGED = "managed";
    public static final String DELETE_NEVER = "never";
    private static final List<String> s_deleteValues = ImmutableList.of((Object)"always", (Object)"managed", (Object)"never");
    @XmlAttribute(name="begin")
    private Long m_begin;
    @XmlAttribute(name="end")
    private Long m_end;
    private String m_delete;
    @XmlAttribute(name="interval")
    private Long m_interval;

    public Downtime() {
    }

    public Downtime(long interval, long begin, long end) {
        this();
        this.setInterval(interval);
        this.setBegin(begin);
        this.setEnd(end);
    }

    public Downtime(long begin, String delete) {
        this();
        this.setBegin(begin);
        this.setDelete(delete);
    }

    public Long getBegin() {
        return this.m_begin == null ? 0L : this.m_begin;
    }

    public void setBegin(Long begin) {
        this.m_begin = begin;
    }

    @XmlTransient
    public void setBegin(Integer begin) {
        this.m_begin = begin == null ? null : Long.valueOf(begin.longValue());
    }

    public Long getEnd() {
        return this.m_end == null ? 0L : this.m_end;
    }

    public void setEnd(Long end) {
        this.m_end = end;
    }

    @XmlTransient
    public void setEnd(Integer end) {
        this.m_end = end == null ? null : Long.valueOf(end.longValue());
    }

    public boolean hasEnd() {
        return this.m_end != null;
    }

    @XmlAttribute(name="delete")
    public String getDelete() {
        return this.m_delete;
    }

    public void setDelete(String delete) {
        if ("yes".equals(delete) || "true".equals(delete)) {
            this.m_delete = DELETE_MANAGED;
            return;
        }
        if ("no".equals(delete) || "false".equals(delete)) {
            this.m_delete = DELETE_NEVER;
            return;
        }
        if (delete != null && !s_deleteValues.contains(delete)) {
            throw new IllegalArgumentException("Downtime delete attribute must be one of 'always', 'managed', or 'never', but was '" + delete + "'.");
        }
        this.m_delete = delete;
    }

    public Long getInterval() {
        return this.m_interval == null ? 0L : this.m_interval;
    }

    public void setInterval(Long interval) {
        this.m_interval = interval;
    }

    @XmlTransient
    public void setInterval(Integer interval) {
        this.m_interval = interval == null ? null : Long.valueOf(interval.longValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_begin == null ? 0 : this.m_begin.hashCode());
        result = 31 * result + (this.m_delete == null ? 0 : this.m_delete.hashCode());
        result = 31 * result + (this.m_end == null ? 0 : this.m_end.hashCode());
        result = 31 * result + (this.m_interval == null ? 0 : this.m_interval.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Downtime)) {
            return false;
        }
        Downtime other = (Downtime)obj;
        if (this.m_begin == null ? other.m_begin != null : !this.m_begin.equals(other.m_begin)) {
            return false;
        }
        if (this.m_delete == null ? other.m_delete != null : !this.m_delete.equals(other.m_delete)) {
            return false;
        }
        if (this.m_end == null ? other.m_end != null : !this.m_end.equals(other.m_end)) {
            return false;
        }
        return !(this.m_interval == null ? other.m_interval != null : !this.m_interval.equals(other.m_interval));
    }

    public String toString() {
        return "Downtime [begin=" + this.m_begin + ", end=" + this.m_end + ", delete=" + this.m_delete + ", interval=" + this.m_interval + "]";
    }
}

