/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.ObjectProvider;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplier;
import io.github.toolfactory.jvm.function.catalog.PrivateLookupInMethodHandleSupplier;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.BiFunction;
import io.github.toolfactory.jvm.function.template.Function;
import io.github.toolfactory.jvm.function.util.JavaClass;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.Map;
import sun.misc.Unsafe;

public abstract class DefineHookClassFunction
implements BiFunction<Class<?>, byte[], Class<?>> {
    MethodHandle defineHookClassMethodHandle;
    ThrowExceptionFunction throwExceptionFunction;

    public DefineHookClassFunction(Map<Object, Object> context) {
        ObjectProvider functionProvider = ObjectProvider.get(context);
        this.throwExceptionFunction = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, context);
    }

    public static class ForJava17
    extends DefineHookClassFunction {
        private MethodHandle privateLookupInMethodHandle;
        private MethodHandles.Lookup consulter;

        public ForJava17(Map<Object, Object> context) throws NoSuchMethodException, IllegalAccessException {
            super(context);
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.consulter = functionProvider.getOrBuildObject(ConsulterSupplier.class, context).get();
            this.defineHookClassMethodHandle = this.consulter.findSpecial(MethodHandles.Lookup.class, "defineClass", MethodType.methodType(Class.class, byte[].class), MethodHandles.Lookup.class);
            this.privateLookupInMethodHandle = (MethodHandle)functionProvider.getOrBuildObject(PrivateLookupInMethodHandleSupplier.class, context).get();
        }

        @Override
        public Class<?> apply(Class<?> clientClass, byte[] byteCode) {
            try {
                MethodHandles.Lookup lookup = this.privateLookupInMethodHandle.invoke(clientClass, this.consulter);
                try {
                    return this.defineHookClassMethodHandle.invoke(lookup, byteCode);
                }
                catch (LinkageError exc) {
                    return (Class)JavaClass.extractByUsing(ByteBuffer.wrap(byteCode), new Function<JavaClass, Class<?>>(){

                        @Override
                        public Class<?> apply(JavaClass javaClass) {
                            try {
                                return Class.forName(javaClass.getName());
                            }
                            catch (Throwable inExc) {
                                return (Class)ForJava17.this.throwExceptionFunction.apply(inExc, new Object[0]);
                            }
                        }
                    });
                }
            }
            catch (Throwable exc) {
                return (Class)this.throwExceptionFunction.apply(exc, new Object[0]);
            }
        }
    }

    public static class ForJava9
    extends ForJava7 {
        public ForJava9(Map<Object, Object> context) throws NoSuchMethodException, IllegalAccessException, Throwable {
            super(context);
        }

        @Override
        public MethodHandles.Lookup retrieveConsulter(MethodHandles.Lookup consulter, MethodHandle lookupMethod) throws Throwable {
            return lookupMethod.invoke(this.unsafe.getClass(), consulter);
        }
    }

    public static class ForJava7
    extends DefineHookClassFunction {
        Unsafe unsafe;

        public ForJava7(Map<Object, Object> context) throws NoSuchMethodException, IllegalAccessException, Throwable {
            super(context);
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.unsafe = (Unsafe)functionProvider.getOrBuildObject(UnsafeSupplier.class, context).get();
            this.defineHookClassMethodHandle = this.retrieveConsulter(functionProvider.getOrBuildObject(ConsulterSupplier.class, context).get(), (MethodHandle)functionProvider.getOrBuildObject(PrivateLookupInMethodHandleSupplier.class, context).get()).findSpecial(this.unsafe.getClass(), "defineAnonymousClass", MethodType.methodType(Class.class, Class.class, byte[].class, Object[].class), this.unsafe.getClass());
        }

        public MethodHandles.Lookup retrieveConsulter(MethodHandles.Lookup consulter, MethodHandle privateLookupInMethodHandle) throws Throwable {
            return privateLookupInMethodHandle.invoke(consulter, this.unsafe.getClass());
        }

        @Override
        public Class<?> apply(Class<?> clientClass, byte[] byteCode) {
            try {
                return this.defineHookClassMethodHandle.invoke(this.unsafe, clientClass, byteCode, null);
            }
            catch (Throwable exc) {
                return (Class)this.throwExceptionFunction.apply(exc, new Object[0]);
            }
        }
    }
}

